/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.settings;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javafx.util.StringConverter;
import oshi.SystemInfo;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButtonComponent;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.scenes.settings.JavaSelectorComponent;
import pro.gravit.launcher.client.gui.stage.ConsoleStage;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class SettingsScene
extends AbstractScene {
    private static final long MAX_JAVA_MEMORY_X64 = 32768L;
    private static final long MAX_JAVA_MEMORY_X32 = 1536L;
    private Pane componentList;
    private Label ramLabel;
    private Slider ramSlider;
    private RuntimeSettings.ProfileSettingsView profileSettings;
    private JavaSelectorComponent javaSelector;

    public SettingsScene(JavaFXApplication javaFXApplication) {
        super("scenes/settings/settings.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        long l;
        SystemInfo systemInfo;
        this.componentList = (Pane)((ScrollPane)LookupHelper.lookup((Node)this.layout, "#settingslist")).getContent();
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#console")).setOnAction(actionEvent -> {
            try {
                if (this.application.gui.consoleStage == null) {
                    this.application.gui.consoleStage = new ConsoleStage(this.application);
                }
                if (this.application.gui.consoleStage.isNullScene()) {
                    this.application.gui.consoleStage.setScene(this.application.gui.consoleScene);
                }
                this.application.gui.consoleStage.show();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.ramSlider = (Slider)LookupHelper.lookup((Node)this.layout, "#ramSlider");
        this.ramLabel = (Label)LookupHelper.lookup((Node)this.layout, "#ramLabel");
        try {
            systemInfo = new SystemInfo();
            l = systemInfo.getHardware().getMemory().getTotal() >> 20;
        }
        catch (Throwable throwable) {
            l = 2048L;
        }
        this.ramSlider.setMax((double)Math.min(l, this.getJavaMaxMemory()));
        this.ramSlider.setSnapToTicks(true);
        this.ramSlider.setShowTickMarks(true);
        this.ramSlider.setShowTickLabels(true);
        this.ramSlider.setMinorTickCount(1);
        this.ramSlider.setMajorTickUnit(1024.0);
        this.ramSlider.setBlockIncrement(1024.0);
        this.ramSlider.setLabelFormatter((StringConverter)new StringConverter<Double>(){

            public String toString(Double d) {
                return String.format("%.0fG", d / 1024.0);
            }

            public Double fromString(String string) {
                return null;
            }
        });
        systemInfo = (Hyperlink)LookupHelper.lookup((Node)this.layout, "#folder", "#path");
        systemInfo.setText(DirBridge.dirUpdates.toAbsolutePath().toString());
        systemInfo.setOnAction(actionEvent -> this.application.openURL(DirBridge.dirUpdates.toAbsolutePath().toString()));
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#changeDir")).setOnAction(arg_0 -> this.lambda$doInit$2((Hyperlink)systemInfo, arg_0));
        LookupHelper.lookupIfPossible((Node)this.layout, "#deleteDir").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.deletedir.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.description"), () -> {
            LogHelper.debug("Delete dir: %s", DirBridge.dirUpdates);
            try {
                IOHelper.deleteDir(DirBridge.dirUpdates, false);
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.scenes.settings.deletedir.fail.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.fail.description"));
            }
        }, () -> {}, true)));
        LookupHelper.lookupIfPossible((Node)this.header, "#back").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> {
            try {
                this.profileSettings = null;
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.reset();
    }

    private long getJavaMaxMemory() {
        if (this.application.javaService.isArchAvailable(JVMHelper.ARCH.X86_64) || this.application.javaService.isArchAvailable(JVMHelper.ARCH.ARM64)) {
            return 32768L;
        }
        return 1536L;
    }

    @Override
    public void reset() {
        this.profileSettings = new RuntimeSettings.ProfileSettingsView(this.application.getProfileSettings());
        this.javaSelector = new JavaSelectorComponent(this.application.javaService, this.layout, this.profileSettings, this.application.stateService.getProfile());
        this.ramSlider.setValue((double)this.profileSettings.ram);
        this.ramSlider.valueProperty().addListener((observableValue, number, number2) -> {
            this.profileSettings.ram = number2.intValue();
            this.updateRamLabel();
        });
        this.updateRamLabel();
        Pane pane = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        pane.getChildren().clear();
        ClientProfile clientProfile = this.application.stateService.getProfile();
        ServerButtonComponent serverButtonComponent = ServerMenuScene.getServerButton(this.application, clientProfile);
        serverButtonComponent.addTo(pane);
        serverButtonComponent.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                this.profileSettings.apply();
                this.application.triggerManager.process(clientProfile, this.application.stateService.getOptionalView());
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        serverButtonComponent.enableResetButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.reset()));
        this.componentList.getChildren().clear();
        this.add("Debug", this.profileSettings.debug, bl -> {
            this.profileSettings.debug = bl;
        });
        this.add("AutoEnter", this.profileSettings.autoEnter, bl -> {
            this.profileSettings.autoEnter = bl;
        });
        this.add("Fullscreen", this.profileSettings.fullScreen, bl -> {
            this.profileSettings.fullScreen = bl;
        });
    }

    @Override
    public String getName() {
        return "settings";
    }

    public void add(String string, boolean bl, Consumer<Boolean> consumer) {
        String string2 = String.format("runtime.scenes.settings.properties.%s.name", string.toLowerCase());
        String string3 = String.format("runtime.scenes.settings.properties.%s.description", string.toLowerCase());
        this.add(this.application.getTranslation(string2, string), this.application.getTranslation(string3, string), bl, consumer);
    }

    public void add(String string, String string2, boolean bl, Consumer<Boolean> consumer) {
        VBox vBox = new VBox();
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        vBox.getChildren().add((Object)checkBox);
        vBox.getChildren().add((Object)label);
        vBox.getStyleClass().add((Object)"settings-container");
        checkBox.setSelected(bl);
        checkBox.setText(string);
        checkBox.setOnAction(actionEvent -> consumer.accept(checkBox.isSelected()));
        checkBox.getStyleClass().add((Object)"settings-checkbox");
        label.setText(string2);
        label.setWrapText(true);
        label.getStyleClass().add((Object)"settings-label");
        this.componentList.getChildren().add((Object)vBox);
    }

    public void updateRamLabel() {
        this.ramLabel.setText(this.profileSettings.ram == 0 ? this.application.getTranslation("runtime.scenes.settings.ramAuto") : MessageFormat.format(this.application.getTranslation("runtime.scenes.settings.ram"), this.profileSettings.ram));
    }

    private /* synthetic */ void lambda$doInit$2(Hyperlink hyperlink, ActionEvent actionEvent) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.application.getTranslation("runtime.scenes.settings.dirTitle"));
        directoryChooser.setInitialDirectory(DirBridge.dir.toFile());
        File file = directoryChooser.showDialog((Window)this.application.getMainStage().stage);
        if (file == null) {
            return;
        }
        Path path = file.toPath().toAbsolutePath();
        try {
            DirBridge.move(path);
        }
        catch (IOException iOException) {
            this.errorHandle(iOException);
        }
        this.application.runtimeSettings.updatesDirPath = path.toString();
        this.application.runtimeSettings.updatesDir = path;
        String string = DirBridge.dirUpdates.toString();
        DirBridge.dirUpdates = path;
        for (ClientProfile clientProfile : this.application.stateService.getProfiles()) {
            RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings(clientProfile);
            if (profileSettings.javaPath == null || !profileSettings.javaPath.startsWith(string)) continue;
            profileSettings.javaPath = path.toString().concat(profileSettings.javaPath.substring(string.length()));
        }
        this.application.javaService.update();
        this.javaSelector.reset();
        hyperlink.setText(this.application.runtimeSettings.updatesDirPath);
    }
}

