/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.service;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.request.auth.password.AuthAESPassword;
import pro.gravit.launcher.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.request.auth.password.AuthTOTPPassword;
import pro.gravit.utils.helper.SecurityHelper;

public class AuthService {
    private final LauncherConfig config = Launcher.getConfig();
    private final JavaFXApplication application;

    public AuthService(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public AuthRequest.AuthPasswordInterface makePassword(String string) {
        if (this.config.passwordEncryptKey != null) {
            try {
                return new AuthAESPassword(this.encryptAESPassword(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new AuthPlainPassword(string);
    }

    public AuthRequest.AuthPasswordInterface make2FAPassword(AuthRequest.AuthPasswordInterface authPasswordInterface, String string) {
        Auth2FAPassword auth2FAPassword = new Auth2FAPassword();
        auth2FAPassword.firstPassword = authPasswordInterface;
        auth2FAPassword.secondPassword = new AuthTOTPPassword();
        ((AuthTOTPPassword)auth2FAPassword.secondPassword).totp = string;
        return auth2FAPassword;
    }

    public List<AuthRequest.AuthPasswordInterface> getListFromPassword(AuthRequest.AuthPasswordInterface authPasswordInterface) {
        if (authPasswordInterface instanceof Auth2FAPassword) {
            ArrayList<AuthRequest.AuthPasswordInterface> arrayList = new ArrayList<AuthRequest.AuthPasswordInterface>();
            Auth2FAPassword auth2FAPassword = (Auth2FAPassword)authPasswordInterface;
            arrayList.add(auth2FAPassword.firstPassword);
            arrayList.add(auth2FAPassword.secondPassword);
            return arrayList;
        }
        if (authPasswordInterface instanceof AuthMultiPassword) {
            return ((AuthMultiPassword)authPasswordInterface).list;
        }
        ArrayList<AuthRequest.AuthPasswordInterface> arrayList = new ArrayList<AuthRequest.AuthPasswordInterface>(1);
        arrayList.add(authPasswordInterface);
        return arrayList;
    }

    public AuthRequest.AuthPasswordInterface getPasswordFromList(List<AuthRequest.AuthPasswordInterface> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 2) {
            Auth2FAPassword auth2FAPassword = new Auth2FAPassword();
            auth2FAPassword.firstPassword = list.get(0);
            auth2FAPassword.secondPassword = list.get(1);
            return auth2FAPassword;
        }
        AuthMultiPassword authMultiPassword = new AuthMultiPassword();
        authMultiPassword.list = list;
        return authMultiPassword;
    }

    public AuthRequest makeAuthRequest(String string, AuthRequest.AuthPasswordInterface authPasswordInterface, String string2) {
        return new AuthRequest(string, authPasswordInterface, string2, false, this.application.isDebugMode() ? AuthRequest.ConnectTypes.API : AuthRequest.ConnectTypes.CLIENT);
    }

    private byte[] encryptAESPassword(String string) throws Exception {
        return SecurityHelper.encrypt(Launcher.getConfig().passwordEncryptKey, string);
    }
}

