/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.stage;

import java.io.IOException;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractStage;
import pro.gravit.utils.helper.LogHelper;

public class DialogStage
extends AbstractStage {
    public DialogStage(JavaFXApplication javaFXApplication, String string, AbstractDialog abstractDialog) throws Exception {
        super(javaFXApplication.newStage());
        Image image;
        this.stage.setTitle(string);
        this.stage.initStyle(StageStyle.TRANSPARENT);
        this.stage.setResizable(false);
        this.stage.setOnCloseRequest(windowEvent -> windowEvent.consume());
        try {
            image = new Image(JavaFXApplication.getResourceURL("favicon.png").toString());
            this.stage.getIcons().add((Object)image);
        }
        catch (IOException iOException) {
            LogHelper.error(iOException);
        }
        this.setScene(abstractDialog);
        this.enableMouseDrag((Node)abstractDialog.getLayout());
        image = Screen.getPrimary();
        Rectangle2D rectangle2D = image.getVisualBounds();
        if (rectangle2D.getMaxX() == 0.0 || rectangle2D.getMaxY() == 0.0) {
            rectangle2D = image.getBounds();
        }
        LogHelper.info("Bounds: X: %f Y: %f", rectangle2D.getMaxX(), rectangle2D.getMaxY());
        LookupHelper.Point2D point2D = abstractDialog.getOutSceneCoords(rectangle2D);
        this.stage.setX(point2D.x);
        this.stage.setY(point2D.y);
    }
}

