/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.config;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import pro.gravit.launcher.Launcher;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public interface JsonConfigurableInterface<T> {
    default public void saveConfig() throws IOException {
        this.saveConfig(this.getPath());
    }

    default public void loadConfig() throws IOException {
        this.loadConfig(this.getPath());
    }

    default public void saveConfig(Gson gson, Path path) throws IOException {
        try (BufferedWriter bufferedWriter = IOHelper.newWriter(path);){
            gson.toJson(this.getConfig(), this.getType(), bufferedWriter);
        }
    }

    default public String toJsonString(Gson gson) {
        return gson.toJson(this.getConfig(), this.getType());
    }

    default public String toJsonString() {
        return this.toJsonString(Launcher.gsonManager.configGson);
    }

    default public void loadConfig(Gson gson, Path path) throws IOException {
        if (this.generateConfigIfNotExists(path)) {
            return;
        }
        try (BufferedReader bufferedReader = IOHelper.newReader(path);){
            this.setConfig(gson.fromJson((Reader)bufferedReader, this.getType()));
        }
        catch (Exception exception) {
            LogHelper.error(exception);
            this.resetConfig(path);
        }
    }

    default public void saveConfig(Path path) throws IOException {
        this.saveConfig(Launcher.gsonManager.configGson, path);
    }

    default public void loadConfig(Path path) throws IOException {
        this.loadConfig(Launcher.gsonManager.configGson, path);
    }

    default public void resetConfig() throws IOException {
        this.setConfig(this.getDefaultConfig());
        this.saveConfig();
    }

    default public void resetConfig(Path path) throws IOException {
        this.setConfig(this.getDefaultConfig());
        this.saveConfig(path);
    }

    default public boolean generateConfigIfNotExists(Path path) throws IOException {
        if (IOHelper.isFile(path)) {
            return false;
        }
        this.resetConfig(path);
        return true;
    }

    default public boolean generateConfigIfNotExists() throws IOException {
        if (IOHelper.isFile(this.getPath())) {
            return false;
        }
        this.resetConfig();
        return true;
    }

    public T getConfig();

    public void setConfig(T var1);

    public T getDefaultConfig();

    public Path getPath();

    public Type getType();
}

