/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.hasher;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.EnumSerializer;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class HashedDir
extends HashedEntry {
    @LauncherNetworkAPI
    private final Map<String, HashedEntry> map = new HashMap<String, HashedEntry>(32);

    public HashedDir() {
    }

    public HashedDir(HInput hInput) throws IOException {
        int n = hInput.readLength(0);
        for (int i = 0; i < n; ++i) {
            HashedEntry hashedEntry;
            String string = IOHelper.verifyFileName(hInput.readString(255));
            HashedEntry.Type type = HashedEntry.Type.read(hInput);
            switch (type) {
                case FILE: {
                    hashedEntry = new HashedFile(hInput);
                    break;
                }
                case DIR: {
                    hashedEntry = new HashedDir(hInput);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
                }
            }
            VerifyHelper.putIfAbsent(this.map, string, hashedEntry, String.format("Duplicate dir entry: '%s'", string));
        }
    }

    public HashedDir(Path path, FileNameMatcher fileNameMatcher, boolean bl, boolean bl2) throws IOException {
        IOHelper.walk(path, new HashFileVisitor(path, fileNameMatcher, bl, bl2), true);
    }

    public Diff diff(HashedDir hashedDir, FileNameMatcher fileNameMatcher) {
        HashedDir hashedDir2 = this.sideDiff(hashedDir, fileNameMatcher, new LinkedList<String>(), true);
        HashedDir hashedDir3 = hashedDir.sideDiff(this, fileNameMatcher, new LinkedList<String>(), false);
        return new Diff(hashedDir2, hashedDir3);
    }

    public Diff compare(HashedDir hashedDir, FileNameMatcher fileNameMatcher) {
        HashedDir hashedDir2 = this.sideDiff(hashedDir, fileNameMatcher, new LinkedList<String>(), true);
        HashedDir hashedDir3 = hashedDir.sideDiff(this, fileNameMatcher, new LinkedList<String>(), false);
        return new Diff(hashedDir2, hashedDir3);
    }

    public void remove(String string) {
        this.map.remove(string);
    }

    public void moveTo(String string, HashedDir hashedDir, String string2) {
        HashedEntry hashedEntry = this.map.remove(string);
        hashedDir.map.put(string2, hashedEntry);
    }

    public FindRecursiveResult findRecursive(String string) {
        HashedEntry hashedEntry;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        HashedDir hashedDir = this;
        HashedEntry hashedEntry2 = null;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens() && ((hashedEntry = hashedDir.map.get(string2 = stringTokenizer.nextToken())) != null || stringTokenizer.hasMoreTokens())) {
            if (hashedEntry == null) {
                throw new RuntimeException(String.format("Directory %s not found", string2));
            }
            if (hashedEntry.getType() == HashedEntry.Type.DIR) {
                if (!stringTokenizer.hasMoreTokens()) {
                    hashedEntry2 = hashedEntry;
                    break;
                }
                hashedDir = (HashedDir)hashedEntry;
                continue;
            }
            hashedEntry2 = hashedEntry;
            break;
        }
        return new FindRecursiveResult(hashedDir, hashedEntry2, string2);
    }

    public HashedEntry getEntry(String string) {
        return this.map.get(string);
    }

    @Override
    public HashedEntry.Type getType() {
        return HashedEntry.Type.DIR;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<String, HashedEntry> map() {
        return Collections.unmodifiableMap(this.map);
    }

    public HashedEntry resolve(Iterable<String> iterable) {
        HashedEntry hashedEntry = this;
        for (String string : iterable) {
            if (hashedEntry instanceof HashedDir) {
                hashedEntry = hashedEntry.map.get(string);
                continue;
            }
            return null;
        }
        return hashedEntry;
    }

    private HashedDir sideDiff(HashedDir hashedDir, FileNameMatcher fileNameMatcher, Deque<String> deque, boolean bl) {
        HashedDir hashedDir2 = new HashedDir();
        for (Map.Entry<String, HashedEntry> entry : this.map.entrySet()) {
            String string = entry.getKey();
            HashedEntry hashedEntry = entry.getValue();
            deque.add(string);
            boolean bl2 = fileNameMatcher == null || fileNameMatcher.shouldUpdate(deque);
            HashedEntry.Type type = hashedEntry.getType();
            HashedEntry hashedEntry2 = hashedDir.map.get(string);
            if (hashedEntry2 == null || hashedEntry2.getType() != type) {
                if (bl2 || bl && hashedEntry2 == null) {
                    hashedDir2.map.put(string, hashedEntry);
                    if (!bl) {
                        hashedEntry.flag = true;
                    }
                }
                deque.removeLast();
                continue;
            }
            switch (type) {
                case FILE: {
                    HashedFile hashedFile = (HashedFile)hashedEntry;
                    HashedFile hashedFile2 = (HashedFile)hashedEntry2;
                    if (!bl || !bl2 || hashedFile.isSame(hashedFile2)) break;
                    hashedDir2.map.put(string, hashedEntry);
                    break;
                }
                case DIR: {
                    HashedDir hashedDir3;
                    HashedDir hashedDir4 = (HashedDir)hashedEntry;
                    HashedDir hashedDir5 = (HashedDir)hashedEntry2;
                    if (!bl && !bl2 || (hashedDir3 = hashedDir4.sideDiff(hashedDir5, fileNameMatcher, deque, bl)).isEmpty()) break;
                    hashedDir2.map.put(string, hashedDir3);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
                }
            }
            deque.removeLast();
        }
        return hashedDir2;
    }

    public HashedDir sideCompare(HashedDir hashedDir, FileNameMatcher fileNameMatcher, Deque<String> deque, boolean bl) {
        HashedDir hashedDir2 = new HashedDir();
        for (Map.Entry<String, HashedEntry> entry : this.map.entrySet()) {
            String string = entry.getKey();
            HashedEntry hashedEntry = entry.getValue();
            deque.add(string);
            boolean bl2 = fileNameMatcher == null || fileNameMatcher.shouldUpdate(deque);
            HashedEntry.Type type = hashedEntry.getType();
            HashedEntry hashedEntry2 = hashedDir.map.get(string);
            if (hashedEntry2 == null || hashedEntry2.getType() != type) {
                if (bl2 || bl && hashedEntry2 == null) {
                    hashedDir2.map.put(string, hashedEntry);
                    if (!bl) {
                        hashedEntry.flag = true;
                    }
                }
                deque.removeLast();
                continue;
            }
            switch (type) {
                case FILE: {
                    HashedFile hashedFile = (HashedFile)hashedEntry;
                    HashedFile hashedFile2 = (HashedFile)hashedEntry2;
                    if (!bl || !bl2 || !hashedFile.isSame(hashedFile2)) break;
                    hashedDir2.map.put(string, hashedEntry);
                    break;
                }
                case DIR: {
                    HashedDir hashedDir3;
                    HashedDir hashedDir4 = (HashedDir)hashedEntry;
                    HashedDir hashedDir5 = (HashedDir)hashedEntry2;
                    if (!bl && !bl2 || (hashedDir3 = hashedDir4.sideCompare(hashedDir5, fileNameMatcher, deque, bl)).isEmpty()) break;
                    hashedDir2.map.put(string, hashedDir3);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
                }
            }
            deque.removeLast();
        }
        return hashedDir2;
    }

    @Override
    public long size() {
        return this.map.values().stream().mapToLong(HashedEntry::size).sum();
    }

    @Override
    public void write(HOutput hOutput) throws IOException {
        Set<Map.Entry<String, HashedEntry>> set = this.map.entrySet();
        hOutput.writeLength(set.size(), 0);
        for (Map.Entry<String, HashedEntry> entry : set) {
            hOutput.writeString(entry.getKey(), 255);
            HashedEntry hashedEntry = entry.getValue();
            EnumSerializer.write(hOutput, hashedEntry.getType());
            hashedEntry.write(hOutput);
        }
    }

    public void walk(CharSequence charSequence, WalkCallback walkCallback) throws IOException {
        String string = "";
        this.walk(string, charSequence, walkCallback, true);
    }

    private WalkAction walk(String string, CharSequence charSequence, WalkCallback walkCallback, boolean bl) throws IOException {
        for (Map.Entry<String, HashedEntry> entry : this.map.entrySet()) {
            Object object;
            HashedEntry hashedEntry = entry.getValue();
            if (hashedEntry.getType() == HashedEntry.Type.FILE) {
                if (!(bl ? (object = walkCallback.walked(string + entry.getKey(), entry.getKey(), hashedEntry)) == WalkAction.STOP : (object = walkCallback.walked(string + charSequence + entry.getKey(), entry.getKey(), hashedEntry)) == WalkAction.STOP)) continue;
                return object;
            }
            object = bl ? string + entry.getKey() : string + charSequence + entry.getKey();
            WalkAction walkAction = walkCallback.walked((String)object, entry.getKey(), hashedEntry);
            if (walkAction == WalkAction.STOP) {
                return walkAction;
            }
            walkAction = ((HashedDir)hashedEntry).walk((String)object, charSequence, walkCallback, false);
            if (walkAction != WalkAction.STOP) continue;
            return walkAction;
        }
        return WalkAction.CONTINUE;
    }

    private final class HashFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path dir;
        private final FileNameMatcher matcher;
        private final boolean allowSymlinks;
        private final boolean digest;
        private final Deque<String> path = new LinkedList<String>();
        private final Deque<HashedDir> stack = new LinkedList<HashedDir>();
        private HashedDir current = HashedDir.this;

        private HashFileVisitor(Path path, FileNameMatcher fileNameMatcher, boolean bl, boolean bl2) {
            this.dir = path;
            this.matcher = fileNameMatcher;
            this.allowSymlinks = bl;
            this.digest = bl2;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            FileVisitResult fileVisitResult = super.postVisitDirectory(path, iOException);
            if (this.dir.equals(path)) {
                return fileVisitResult;
            }
            HashedDir hashedDir = this.stack.removeLast();
            hashedDir.map.put(this.path.removeLast(), this.current);
            this.current = hashedDir;
            return fileVisitResult;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            FileVisitResult fileVisitResult = super.preVisitDirectory(path, basicFileAttributes);
            if (this.dir.equals(path)) {
                return fileVisitResult;
            }
            if (!this.allowSymlinks && basicFileAttributes.isSymbolicLink()) {
                throw new SecurityException("Symlinks are not allowed");
            }
            this.stack.add(this.current);
            this.current = new HashedDir();
            this.path.add(IOHelper.getFileName(path));
            return fileVisitResult;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            if (!this.allowSymlinks && basicFileAttributes.isSymbolicLink()) {
                throw new SecurityException("Symlinks are not allowed");
            }
            this.path.add(IOHelper.getFileName(path));
            boolean bl = this.digest && (this.matcher == null || this.matcher.shouldUpdate(this.path));
            this.current.map.put(this.path.removeLast(), new HashedFile(path, basicFileAttributes.size(), bl));
            return super.visitFile(path, basicFileAttributes);
        }
    }

    public static final class Diff {
        public final HashedDir mismatch;
        public final HashedDir extra;

        private Diff(HashedDir hashedDir, HashedDir hashedDir2) {
            this.mismatch = hashedDir;
            this.extra = hashedDir2;
        }

        public boolean isSame() {
            return this.mismatch.isEmpty() && this.extra.isEmpty();
        }
    }

    public static class FindRecursiveResult {
        public final HashedDir parent;
        public final HashedEntry entry;
        public final String name;

        public FindRecursiveResult(HashedDir hashedDir, HashedEntry hashedEntry, String string) {
            this.parent = hashedDir;
            this.entry = hashedEntry;
            this.name = string;
        }
    }

    @FunctionalInterface
    public static interface WalkCallback {
        public WalkAction walked(String var1, String var2, HashedEntry var3) throws IOException;
    }

    public static enum WalkAction {
        STOP,
        CONTINUE;

    }
}

