/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.RefreshTokenRequestEvent;
import pro.gravit.launcher.events.request.RestoreRequestEvent;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.request.auth.RestoreRequest;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.TypeSerializeInterface;
import pro.gravit.utils.helper.LogHelper;

public abstract class Request<R extends WebSocketEvent>
implements WebSocketRequest {
    private static final List<ExtendedTokenCallback> extendedTokenCallbacks = new ArrayList<ExtendedTokenCallback>(4);
    private static final List<BiConsumer<String, AuthRequestEvent.OAuthRequestEvent>> oauthChangeHandlers = new ArrayList<BiConsumer<String, AuthRequestEvent.OAuthRequestEvent>>(4);
    @Deprecated
    public static StdWebSocketService service;
    private static RequestService requestService;
    private static AuthRequestEvent.OAuthRequestEvent oauth;
    private static Map<String, String> extendedTokens;
    private static String authId;
    private static long tokenExpiredTime;
    @LauncherNetworkAPI
    public final UUID requestUUID = UUID.randomUUID();
    private final transient AtomicBoolean started = new AtomicBoolean(false);

    public static RequestService getRequestService() {
        return requestService;
    }

    public static void setRequestService(RequestService requestService) {
        Request.requestService = requestService;
        if (requestService instanceof StdWebSocketService) {
            service = (StdWebSocketService)requestService;
        }
    }

    public static boolean isAvailable() {
        return requestService != null;
    }

    public static void setOAuth(String string, AuthRequestEvent.OAuthRequestEvent oAuthRequestEvent) {
        oauth = oAuthRequestEvent;
        authId = string;
        tokenExpiredTime = oauth != null && Request.oauth.expire != 0L ? System.currentTimeMillis() + Request.oauth.expire : 0L;
        for (BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> biConsumer : oauthChangeHandlers) {
            biConsumer.accept(string, oAuthRequestEvent);
        }
    }

    public static AuthRequestEvent.OAuthRequestEvent getOAuth() {
        return oauth;
    }

    public static String getAuthId() {
        return authId;
    }

    public static Map<String, String> getExtendedTokens() {
        if (extendedTokens != null) {
            return Collections.unmodifiableMap(extendedTokens);
        }
        return null;
    }

    public static void clearExtendedTokens() {
        if (extendedTokens != null) {
            extendedTokens.clear();
        }
    }

    public static void addExtendedToken(String string, String string2) {
        if (extendedTokens == null) {
            extendedTokens = new HashMap<String, String>();
        }
        extendedTokens.put(string, string2);
    }

    public static void addAllExtendedToken(Map<String, String> map) {
        if (extendedTokens == null) {
            extendedTokens = new HashMap<String, String>();
        }
        extendedTokens.putAll(map);
    }

    public static void setOAuth(String string, AuthRequestEvent.OAuthRequestEvent oAuthRequestEvent, long l) {
        oauth = oAuthRequestEvent;
        authId = string;
        tokenExpiredTime = l;
    }

    public static boolean isTokenExpired() {
        if (oauth == null) {
            return true;
        }
        if (tokenExpiredTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() > tokenExpiredTime;
    }

    public static long getTokenExpiredTime() {
        return tokenExpiredTime;
    }

    public static String getAccessToken() {
        return oauth == null ? null : Request.oauth.accessToken;
    }

    public static String getRefreshToken() {
        return oauth == null ? null : Request.oauth.refreshToken;
    }

    public static void reconnect() throws Exception {
        service.open();
        Request.restore();
    }

    public static RequestRestoreReport restore() throws Exception {
        RestoreRequest restoreRequest;
        Object object;
        TypeSerializeInterface typeSerializeInterface;
        boolean bl = false;
        if (oauth != null) {
            if (Request.isTokenExpired() || Request.oauth.accessToken == null) {
                typeSerializeInterface = new RefreshTokenRequest(authId, Request.oauth.refreshToken);
                object = (RefreshTokenRequestEvent)typeSerializeInterface.request();
                Request.setOAuth(authId, ((RefreshTokenRequestEvent)object).oauth);
                bl = true;
            }
            restoreRequest = new RestoreRequest(authId, Request.oauth.accessToken, extendedTokens, false);
        } else {
            restoreRequest = new RestoreRequest(authId, null, extendedTokens, false);
        }
        typeSerializeInterface = (RestoreRequestEvent)restoreRequest.request();
        object = null;
        if (((RestoreRequestEvent)typeSerializeInterface).invalidTokens != null && ((RestoreRequestEvent)typeSerializeInterface).invalidTokens.size() > 0) {
            boolean bl2 = false;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (ExtendedTokenCallback extendedTokenCallback : extendedTokenCallbacks) {
                for (String string : ((RestoreRequestEvent)typeSerializeInterface).invalidTokens) {
                    String string2 = extendedTokenCallback.tryGetNewToken(string);
                    if (string2 == null) continue;
                    bl2 = true;
                    hashMap.put(string, string2);
                    Request.addExtendedToken(string, string2);
                }
            }
            if (bl2) {
                restoreRequest = new RestoreRequest(authId, null, hashMap, false);
                typeSerializeInterface = (RestoreRequestEvent)restoreRequest.request();
                if (((RestoreRequestEvent)typeSerializeInterface).invalidTokens != null && ((RestoreRequestEvent)typeSerializeInterface).invalidTokens.size() > 0) {
                    LogHelper.warning("Tokens %s not restored", String.join((CharSequence)",", ((RestoreRequestEvent)typeSerializeInterface).invalidTokens));
                }
            }
            object = ((RestoreRequestEvent)typeSerializeInterface).invalidTokens;
        }
        return new RequestRestoreReport(false, bl, (List<String>)object);
    }

    public static void requestError(String string) throws RequestException {
        throw new RequestException(string);
    }

    public void addExtendedTokenCallback(ExtendedTokenCallback extendedTokenCallback) {
        extendedTokenCallbacks.add(extendedTokenCallback);
    }

    public void removeExtendedTokenCallback(ExtendedTokenCallback extendedTokenCallback) {
        extendedTokenCallbacks.remove(extendedTokenCallback);
    }

    public void addOAuthChangeHandler(BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> biConsumer) {
        oauthChangeHandlers.add(biConsumer);
    }

    public void removeOAuthChangeHandler(BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> biConsumer) {
        oauthChangeHandlers.remove(biConsumer);
    }

    public R request() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        if (!Request.isAvailable()) {
            throw new RequestException("RequestService not initialized");
        }
        return this.requestDo(requestService);
    }

    @Deprecated
    public R request(StdWebSocketService stdWebSocketService) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(stdWebSocketService);
    }

    public R request(RequestService requestService) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(requestService);
    }

    protected R requestDo(RequestService requestService) throws Exception {
        return (R)requestService.requestSync(this);
    }

    public static class RequestRestoreReport {
        public final boolean legacySession;
        public final boolean refreshed;
        public final List<String> invalidExtendedTokens;

        public RequestRestoreReport(boolean bl, boolean bl2, List<String> list) {
            this.legacySession = bl;
            this.refreshed = bl2;
            this.invalidExtendedTokens = list;
        }
    }

    public static interface ExtendedTokenCallback {
        public String tryGetNewToken(String var1);
    }
}

