/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.utils;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public final class DirWatcher
implements Runnable,
AutoCloseable {
    public static final boolean FILE_TREE_SUPPORTED = JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE;
    public static final String IGN_OVERFLOW = "launcher.dirwatcher.ignoreOverflows";
    private static final WatchEvent.Kind<?>[] KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
    private static final boolean PROP_IGN_OVERFLOW = Boolean.parseBoolean(System.getProperty("launcher.dirwatcher.ignoreOverflows", "true"));
    private final Path dir;
    private final HashedDir hdir;
    private final FileNameMatcher matcher;
    private final WatchService service;
    private final boolean digest;

    public DirWatcher(Path path, HashedDir hashedDir, FileNameMatcher fileNameMatcher, boolean bl) throws IOException {
        this.dir = Objects.requireNonNull(path, "dir");
        this.hdir = Objects.requireNonNull(hashedDir, "hdir");
        this.matcher = fileNameMatcher;
        this.digest = bl;
        this.service = path.getFileSystem().newWatchService();
        IOHelper.walk(path, new RegisterFileVisitor(), true);
        LogHelper.subInfo("DirWatcher %s", path.toString());
    }

    private static void handleError(Throwable throwable) {
        LogHelper.error(throwable);
        LauncherEngine.exitLauncher(-123);
    }

    private static Deque<String> toPath(Iterable<Path> iterable) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Path path : iterable) {
            linkedList.add(path.toString());
        }
        return linkedList;
    }

    @Override
    public void close() throws IOException {
        this.service.close();
    }

    private void processKey(WatchKey watchKey) throws IOException {
        Path path = (Path)watchKey.watchable();
        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
            HashedEntry hashedEntry;
            WatchEvent.Kind<?> kind = watchEvent.kind();
            if (kind.equals(StandardWatchEventKinds.OVERFLOW)) {
                if (PROP_IGN_OVERFLOW) continue;
                throw new IOException("Overflow");
            }
            Path path2 = path.resolve((Path)watchEvent.context());
            Deque<String> deque = DirWatcher.toPath(this.dir.relativize(path2));
            if (this.matcher != null && !this.matcher.shouldVerify(deque) || kind.equals(StandardWatchEventKinds.ENTRY_MODIFY) && (hashedEntry = this.hdir.resolve(deque)) != null && (hashedEntry.getType() != HashedEntry.Type.FILE || ((HashedFile)hashedEntry).isSame(path2, this.digest))) continue;
            throw new SecurityException(String.format("Forbidden modification (%s, %d times): '%s'", kind, watchEvent.count(), path2));
        }
        watchKey.reset();
    }

    private void processLoop() throws IOException, InterruptedException {
        LogHelper.debug("WatchService start processing");
        while (!Thread.interrupted()) {
            this.processKey(this.service.take());
        }
        LogHelper.debug("WatchService closed");
    }

    @Override
    public void run() {
        try {
            this.processLoop();
        }
        catch (InterruptedException | ClosedWatchServiceException exception) {
            LogHelper.debug("WatchService closed 2");
        }
        catch (Throwable throwable) {
            DirWatcher.handleError(throwable);
        }
    }

    private final class RegisterFileVisitor
    extends SimpleFileVisitor<Path> {
        private RegisterFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            FileVisitResult fileVisitResult = super.preVisitDirectory(path, basicFileAttributes);
            path.register(DirWatcher.this.service, KINDS);
            return fileVisitResult;
        }
    }
}

