/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchermodules.discordgame;

import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientUnlockConsoleEvent;
import pro.gravit.launcher.client.events.client.ClientProcessBuilderParamsWrittedEvent;
import pro.gravit.launcher.client.events.client.ClientProcessLaunchEvent;
import pro.gravit.launcher.modules.LauncherInitContext;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.launcher.request.Request;
import pro.gravit.launchermodules.discordgame.Config;
import pro.gravit.launchermodules.discordgame.DiscordBridge;
import pro.gravit.launchermodules.discordgame.RequestEventWatcher;
import pro.gravit.launchermodules.discordgame.ScopeConfig;
import pro.gravit.launchermodules.discordgame.commands.DiscordCommand;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.LogHelper;

public class ClientModule
extends LauncherModule {
    public static final Version version = new Version(1, 1, 0, 1, Version.Type.LTS);
    private static final Object lock = new Object();
    public static Config config;
    public static ScopeConfig loginScopeConfig;
    public static ScopeConfig authorizedScopeConfig;
    public static ScopeConfig clientScopeConfig;
    private static volatile boolean isClosed;

    public ClientModule() {
        super(new LauncherModuleInfo("DiscordGame", version, new String[]{"ClientLauncherCore"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isClosed(boolean bl) {
        boolean bl2;
        Object object = lock;
        synchronized (object) {
            bl2 = isClosed;
            if (bl) {
                isClosed = true;
            }
            lock.notify();
        }
        return bl2;
    }

    @Override
    public void init(LauncherInitContext launcherInitContext) {
        config = new Config();
        loginScopeConfig = new ScopeConfig(ClientModule.config.scopes.get("login"));
        authorizedScopeConfig = new ScopeConfig(ClientModule.config.scopes.get("authorized"));
        clientScopeConfig = new ScopeConfig(ClientModule.config.scopes.get("client"));
        this.registerEvent(this::clientInit, ClientProcessLaunchEvent.class);
        this.registerEvent(this::launcherInit, ClientEngineInitPhase.class);
        this.registerEvent(this::exitHandler, ClientExitPhase.class);
        this.registerEvent(this::exitByStartClient, ClientProcessBuilderParamsWrittedEvent.class);
    }

    private void clientInit(ClientProcessLaunchEvent clientProcessLaunchEvent) {
        DiscordBridge.activityService.updateClientStage(clientProcessLaunchEvent.params);
        try {
            DiscordBridge.init(ClientModule.config.appId);
            RequestEventWatcher.INSTANCE = new RequestEventWatcher(true);
            Request.getRequestService().registerEventHandler(RequestEventWatcher.INSTANCE);
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
        }
    }

    private void unlock(ClientUnlockConsoleEvent clientUnlockConsoleEvent) {
        clientUnlockConsoleEvent.handler.registerCommand("discord", new DiscordCommand());
    }

    private void launcherInit(ClientEngineInitPhase clientEngineInitPhase) {
        DiscordBridge.activityService.updateLoginStage();
        try {
            DiscordBridge.init(ClientModule.config.appId);
            RequestEventWatcher.INSTANCE = new RequestEventWatcher(false);
            Request.getRequestService().registerEventHandler(RequestEventWatcher.INSTANCE);
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
        }
    }

    private void exitHandler(ClientExitPhase clientExitPhase) {
        if (ClientModule.isClosed(true)) {
            return;
        }
        if (RequestEventWatcher.INSTANCE != null) {
            Request.getRequestService().unregisterEventHandler(RequestEventWatcher.INSTANCE);
        }
        DiscordBridge.close();
    }

    private void exitByStartClient(ClientProcessBuilderParamsWrittedEvent clientProcessBuilderParamsWrittedEvent) {
    }

    static {
        isClosed = false;
    }
}

