/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchermodules.myhttp;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.ClientPermissions;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.base.request.auth.details.AuthTotpDetails;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.base.request.auth.password.AuthTOTPPassword;
import pro.gravit.launcher.base.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.HttpRequester;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.UserHardware;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.session.UserSessionSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportTextures;
import pro.gravit.launchserver.auth.texture.JsonTextureProvider;
import pro.gravit.launchserver.helper.HttpHelper;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;

public class MyHttpAuthCoreProvider
extends AuthCoreProvider
implements AuthSupportHardware {
    private static final int CODE_TOKEN_EXPIRED = 1001;
    private static final int CODE_INVALID_REFRESH_TOKEN = 1002;
    private final transient Logger logger = LogManager.getLogger();
    public String userByUsername;
    public String userByUuid;
    public String refreshAccessToken;
    public String authorize;
    public String userByToken;
    public String checkServer;
    public String joinServer;
    public String bearerToken;
    public String getHardwareInfoByPublicKeyUrl;
    public String getHardwareInfoByDataUrl;
    public String getHardwareInfoByIdUrl;
    public String createHardwareInfoUrl;
    public String connectUserAndHardwareUrl;
    public String addPublicKeyToHardwareInfoUrl;
    public String getUsersByHardwareInfoUrl;
    public String banHardwareUrl;
    public String unbanHardwareUrl;
    private transient HttpRequester requester;

    public User getUserByUsername(String string) {
        try {
            HttpHelper.HttpOptional httpOptional = this.requester.send(this.requester.get(this.userByUsername.replace("%username%", URLEncoder.encode(string, StandardCharsets.UTF_8)), this.bearerToken), MyHttpUser.class);
            if (httpOptional.isSuccessful()) {
                return (User)httpOptional.result();
            }
            if (httpOptional.statusCode() == 404) {
                return null;
            }
            this.logger.error("getUserByUsername: {}", (Object)((HttpRequester.SimpleError)httpOptional.error()).toString());
            return null;
        }
        catch (Throwable throwable) {
            this.logger.error("getUserByUsername", throwable);
            return null;
        }
    }

    public User getUserByUUID(UUID uUID) {
        try {
            HttpHelper.HttpOptional httpOptional = this.requester.send(this.requester.get(this.userByUuid.replace("%uuid%", uUID.toString()), this.bearerToken), MyHttpUser.class);
            if (httpOptional.isSuccessful()) {
                return (User)httpOptional.result();
            }
            if (httpOptional.statusCode() == 404) {
                return null;
            }
            this.logger.error("getUserByUUID: {}", (Object)((HttpRequester.SimpleError)httpOptional.error()).toString());
            return null;
        }
        catch (Throwable throwable) {
            this.logger.error("getUserByUUID", throwable);
            return null;
        }
    }

    public UserSession getUserSessionByOAuthAccessToken(String string) throws AuthCoreProvider.OAuthAccessTokenExpired {
        HttpHelper.HttpOptional httpOptional;
        try {
            httpOptional = this.requester.send(this.requester.post(this.userByToken, (Object)new GetUserByAccessTokenRequest(string), this.bearerToken), MyHttpUserSession.class);
        }
        catch (Throwable throwable) {
            this.logger.error("getUserSessionByOAuthAccessToken", throwable);
            return null;
        }
        if (httpOptional.isSuccessful()) {
            return (UserSession)httpOptional.result();
        }
        if (((HttpRequester.SimpleError)httpOptional.error()).code == 1001) {
            throw new AuthCoreProvider.OAuthAccessTokenExpired();
        }
        this.logger.error("getUserSessionByOAuthAccessToken: {}", (Object)((HttpRequester.SimpleError)httpOptional.error()).toString());
        return null;
    }

    public AuthManager.AuthReport refreshAccessToken(String string, AuthResponse.AuthContext authContext) {
        HttpHelper.HttpOptional httpOptional;
        try {
            httpOptional = this.requester.send(this.requester.post(this.refreshAccessToken, (Object)new RefreshTokenRequest(string), this.bearerToken), MyHttpUserSession.class);
        }
        catch (Throwable throwable) {
            this.logger.error("refreshAccessToken", throwable);
            return null;
        }
        if (httpOptional.isSuccessful()) {
            return ((MyHttpUserSession)httpOptional.result()).toAuthReport();
        }
        if (((HttpRequester.SimpleError)httpOptional.error()).code == 1002) {
            return null;
        }
        this.logger.error("refreshAccessToken: {}", (Object)((HttpRequester.SimpleError)httpOptional.error()).toString());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthManager.AuthReport authorize(String string, AuthResponse.AuthContext authContext, AuthRequest.AuthPasswordInterface authPasswordInterface, boolean bl) throws IOException {
        String string2;
        String string3;
        AuthPlainPassword authPlainPassword;
        if (string == null || authPasswordInterface == null) {
            throw new AuthException("Empty login or password");
        }
        if (authPasswordInterface instanceof AuthPlainPassword) {
            authPlainPassword = (AuthPlainPassword)authPasswordInterface;
            string3 = authPlainPassword.password;
            string2 = null;
        } else {
            if (!(authPasswordInterface instanceof Auth2FAPassword)) throw new AuthException("Unsupported password type");
            Auth2FAPassword auth2FAPassword = (Auth2FAPassword)authPasswordInterface;
            AuthRequest.AuthPasswordInterface authPasswordInterface2 = auth2FAPassword.firstPassword;
            if (!(authPasswordInterface2 instanceof AuthPlainPassword)) {
                throw new AuthException("Unsupported password type (first)");
            }
            AuthPlainPassword authPlainPassword2 = (AuthPlainPassword)authPasswordInterface2;
            string3 = authPlainPassword2.password;
            AuthRequest.AuthPasswordInterface authPasswordInterface3 = auth2FAPassword.secondPassword;
            if (!(authPasswordInterface3 instanceof AuthTOTPPassword)) throw new AuthException("Unsupported password type (second)");
            authPasswordInterface2 = (AuthTOTPPassword)authPasswordInterface3;
            string2 = authPasswordInterface2.totp;
        }
        try {
            authPlainPassword = this.requester.send(this.requester.post(this.authorize, (Object)new AuthorizeRequest(string, string3, string2), this.bearerToken), MyHttpUserSession.class);
        }
        catch (Throwable throwable) {
            this.logger.error("authorize", throwable);
            throw new AuthException("Unexpected server error. Please contact administrator");
        }
        if (!authPlainPassword.isSuccessful()) throw new AuthException(((HttpRequester.SimpleError)authPlainPassword.error()).error);
        return ((MyHttpUserSession)authPlainPassword.result()).toAuthReport();
    }

    public void init(LaunchServer launchServer, AuthProviderPair authProviderPair) {
        super.init(launchServer, authProviderPair);
        this.requester = new HttpRequester();
    }

    public User checkServer(Client client, String string, String string2) throws IOException {
        HttpHelper.HttpOptional httpOptional;
        try {
            httpOptional = this.requester.send(this.requester.post(this.checkServer, (Object)new CheckServerRequest(string, string2), this.bearerToken), MyHttpUser.class);
        }
        catch (Throwable throwable) {
            this.logger.error("checkServer", throwable);
            throw new AuthException("Unexpected server error. Please contact administrator");
        }
        if (httpOptional.isSuccessful()) {
            return (User)httpOptional.result();
        }
        throw new AuthException(((HttpRequester.SimpleError)httpOptional.error()).error);
    }

    public boolean joinServer(Client client, String string, UUID uUID, String string2, String string3) throws IOException {
        HttpHelper.HttpOptional httpOptional;
        try {
            httpOptional = this.requester.send(this.requester.post(this.joinServer, (Object)new JoinServerRequest(string, uUID, string2, string3), this.bearerToken), Void.class);
        }
        catch (Throwable throwable) {
            this.logger.error("joinServer", throwable);
            throw new AuthException("Unexpected server error. Please contact administrator");
        }
        if (httpOptional.isSuccessful()) {
            return true;
        }
        throw new AuthException(((HttpRequester.SimpleError)httpOptional.error()).error);
    }

    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails(Client client) {
        return List.of(new AuthPasswordDetails(), new AuthTotpDetails("UNKNOWN", 6));
    }

    public void close() {
    }

    public MyHttpUserHardware getHardwareInfoByPublicKey(byte[] byArray) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            httpOptional = this.requester.send(this.requester.post(this.getHardwareInfoByPublicKeyUrl, (Object)new HardwareInfoRequest(byArray), this.bearerToken), MyHttpUserHardware.class);
        }
        catch (Throwable throwable) {
            this.logger.error("getHardwareInfoByPublicKey", throwable);
        }
        if (httpOptional != null && httpOptional.statusCode() == 200) {
            MyHttpUserHardware myHttpUserHardware = (MyHttpUserHardware)httpOptional.result();
            this.logger.debug("Successfully got UserHardware {} by publicKey", (Object)myHttpUserHardware.id);
            return myHttpUserHardware;
        }
        if (httpOptional != null && httpOptional.statusCode() == 204) {
            this.logger.debug("UserHardware not found by publicKey");
            return null;
        }
        this.logger.debug("Something went wrong while getting UserHardware by publicKey");
        return null;
    }

    public MyHttpUserHardware getHardwareInfoById(String string) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            httpOptional = this.requester.send(this.requester.post(this.getHardwareInfoByIdUrl, (Object)new HardwareInfoRequest(string), this.bearerToken), MyHttpUserHardware.class);
        }
        catch (Throwable throwable) {
            this.logger.error("getHardwareInfoById", throwable);
        }
        if (httpOptional != null && httpOptional.statusCode() == 200) {
            MyHttpUserHardware myHttpUserHardware = (MyHttpUserHardware)httpOptional.result();
            this.logger.debug("Successfully got UserHardware by id {}", (Object)string);
            return myHttpUserHardware;
        }
        if (httpOptional != null && httpOptional.statusCode() == 204) {
            this.logger.debug("UserHardware not found by publicKey");
            return null;
        }
        this.logger.debug("Something went wrong while getting UserHardware by id {}", (Object)string);
        return null;
    }

    public void connectUserAndHardware(UserSession userSession, UserHardware userHardware) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            String string = userSession.getID();
            this.logger.debug("Connecting user {} to hardware {}", (Object)string, (Object)userHardware.getId());
            httpOptional = this.requester.send(this.requester.post(this.connectUserAndHardwareUrl, (Object)new UserHardwareRequest((MyHttpUserHardware)userHardware, string), this.bearerToken), MyHttpSimpleResponse.class);
        }
        catch (Throwable throwable) {
            this.logger.error("connectUserAndHardware", throwable);
        }
        if (httpOptional != null && httpOptional.isSuccessful()) {
            this.logger.debug("Successfully connected user {} to hardware", (Object)userSession.getUser().getUUID());
            return;
        }
        this.logger.debug("Something went wrong while connecting user {} to hardware", (Object)userSession.getUser().getUUID());
    }

    public void addPublicKeyToHardwareInfo(UserHardware userHardware, byte[] byArray) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            httpOptional = this.requester.send(this.requester.post(this.addPublicKeyToHardwareInfoUrl, (Object)new UserHardwareRequest((MyHttpUserHardware)userHardware, byArray), this.bearerToken), MyHttpSimpleResponse.class);
        }
        catch (Throwable throwable) {
            this.logger.error("addPublicKeyToHardwareInfo", throwable);
        }
        if (httpOptional != null && httpOptional.isSuccessful()) {
            this.logger.debug("Successfully connected user hardware {} to public key", (Object)userHardware.getId());
            return;
        }
        this.logger.debug("Something went wrong while connecting user hardware {} to public key", (Object)userHardware.getId());
    }

    public Iterable<User> getUsersByHardwareInfo(UserHardware userHardware) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            httpOptional = this.requester.send(this.requester.post(this.getUsersByHardwareInfoUrl, (Object)new UserHardwareRequest((MyHttpUserHardware)userHardware), this.bearerToken), new TypeToken<List<MyHttpUser>>(this){}.getType());
        }
        catch (Throwable throwable) {
            this.logger.error("getUsersByHardwareInfo", throwable);
        }
        if (httpOptional != null && httpOptional.isSuccessful()) {
            this.logger.debug("Successfully got users by hardware info");
            return ((List)httpOptional.result()).stream().map(myHttpUser -> myHttpUser).toList();
        }
        this.logger.debug("Something went wrong while connecting user hardware {} to public key", (Object)userHardware.getId());
        return Collections.emptyList();
    }

    public void banHardware(UserHardware userHardware) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            httpOptional = this.requester.send(this.requester.post(this.banHardwareUrl, (Object)new UserHardwareRequest((MyHttpUserHardware)userHardware), this.bearerToken), MyHttpSimpleResponse.class);
        }
        catch (Throwable throwable) {
            this.logger.error("banHardware", throwable);
        }
        if (httpOptional != null && httpOptional.isSuccessful()) {
            this.logger.debug("Successfully banned hardware with id {}", (Object)userHardware.getId());
            return;
        }
        this.logger.debug("Something went wrong while bannind hardware with id {}", (Object)userHardware.getId());
    }

    public void unbanHardware(UserHardware userHardware) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            httpOptional = this.requester.send(this.requester.post(this.unbanHardwareUrl, (Object)new UserHardwareRequest((MyHttpUserHardware)userHardware), this.bearerToken), MyHttpSimpleResponse.class);
        }
        catch (Throwable throwable) {
            this.logger.error("unbanHardware", throwable);
        }
        if (httpOptional != null && httpOptional.isSuccessful()) {
            this.logger.debug("Successfully unbanned hardware with id {}", (Object)userHardware.getId());
            return;
        }
        this.logger.debug("Something went wrong while unbanning hardware with id {}", (Object)userHardware.getId());
    }

    public UserHardware getHardwareInfoByData(HardwareReportRequest.HardwareInfo hardwareInfo) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            httpOptional = this.requester.send(this.requester.post(this.getHardwareInfoByDataUrl, (Object)new HardwareInfoRequest(hardwareInfo), this.bearerToken), MyHttpUserHardware.class);
        }
        catch (Throwable throwable) {
            this.logger.error("getHardwareInfoByData", throwable);
        }
        if (httpOptional != null && httpOptional.statusCode() == 200) {
            MyHttpUserHardware myHttpUserHardware = (MyHttpUserHardware)httpOptional.result();
            this.logger.debug("Successfully got UserHardware {} by info", (Object)myHttpUserHardware.id);
            return myHttpUserHardware;
        }
        if (httpOptional != null && httpOptional.statusCode() == 204) {
            this.logger.debug("UserHardware not found by hardware info");
            return null;
        }
        this.logger.debug("Something went wrong while getting UserHardware by info");
        return null;
    }

    public UserHardware createHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] byArray) {
        HttpHelper.HttpOptional httpOptional = null;
        try {
            httpOptional = this.requester.send(this.requester.post(this.createHardwareInfoUrl, (Object)new HardwareInfoRequest(hardwareInfo, byArray), this.bearerToken), MyHttpUserHardware.class);
        }
        catch (Throwable throwable) {
            this.logger.error("createHardwareInfo", throwable);
        }
        if (httpOptional != null && httpOptional.isSuccessful()) {
            MyHttpUserHardware myHttpUserHardware = (MyHttpUserHardware)httpOptional.result();
            this.logger.debug("Successfully created UserHardware");
            return myHttpUserHardware;
        }
        this.logger.debug("Something went wrong while creating UserHardware");
        throw new SecurityException("Please contact administrator");
    }

    public record MyHttpUser(String username, UUID uuid, List<String> permissions, List<String> roles, Map<String, JsonTextureProvider.JsonTexture> assets, boolean banned, UserHardware userHardware) implements User,
    UserSupportTextures
    {
        public String getUsername() {
            return this.username;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public ClientPermissions getPermissions() {
            return new ClientPermissions(this.roles, this.permissions);
        }

        public boolean isBanned() {
            return this.banned;
        }

        public Texture getSkinTexture() {
            JsonTextureProvider.JsonTexture jsonTexture = this.assets.get("SKIN");
            if (jsonTexture != null) {
                return jsonTexture.toTexture();
            }
            return null;
        }

        public Texture getCloakTexture() {
            JsonTextureProvider.JsonTexture jsonTexture = this.assets.get("CAPE");
            if (jsonTexture != null) {
                return jsonTexture.toTexture();
            }
            return null;
        }

        public Map<String, Texture> getUserAssets() {
            return JsonTextureProvider.JsonTexture.convertMap(this.assets);
        }
    }

    public record GetUserByAccessTokenRequest(String accessToken) {
    }

    public record MyHttpUserSession(String id, String accessToken, String refreshToken, int expire, MyHttpUser user, String hardwareId, UserHardware userHardware) implements UserSession,
    UserSessionSupportHardware
    {
        public String getID() {
            return this.id;
        }

        public User getUser() {
            return this.user;
        }

        public String getMinecraftAccessToken() {
            return this.accessToken;
        }

        public long getExpireIn() {
            return (long)this.expire * 1000L;
        }

        public AuthManager.AuthReport toAuthReport() {
            return new AuthManager.AuthReport(this.accessToken, this.accessToken, this.refreshToken, (long)this.expire * 1000L, (UserSession)this);
        }

        public String getHardwareId() {
            return this.hardwareId;
        }

        public UserHardware getHardware() {
            return this.userHardware;
        }
    }

    public record RefreshTokenRequest(String refreshToken) {
    }

    public record AuthorizeRequest(String login, String password, String totpCode) {
    }

    public record CheckServerRequest(String username, String serverId) {
    }

    public record JoinServerRequest(String username, UUID uuid, String accessToken, String serverId) {
    }

    public record HardwareInfoRequest(HardwareReportRequest.HardwareInfo info, byte[] publicKey, String id) {
        HardwareInfoRequest(HardwareReportRequest.HardwareInfo hardwareInfo) {
            this(hardwareInfo, null, null);
        }

        HardwareInfoRequest(byte[] byArray) {
            this(null, byArray, null);
        }

        HardwareInfoRequest(String string) {
            this(null, null, string);
        }

        HardwareInfoRequest(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] byArray) {
            this(hardwareInfo, byArray, null);
        }
    }

    public record MyHttpUserHardware(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, String id, boolean banned) implements UserHardware
    {
        public HardwareReportRequest.HardwareInfo getHardwareInfo() {
            return this.hardwareInfo;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }

        public String getId() {
            return this.id;
        }

        public boolean isBanned() {
            return this.banned;
        }
    }

    public record UserHardwareRequest(MyHttpUserHardware hardware, MyHttpUserSession userSession, byte[] publicKey, String sessionID) {
        public UserHardwareRequest(MyHttpUserHardware myHttpUserHardware) {
            this(myHttpUserHardware, null, null, null);
        }

        public UserHardwareRequest(MyHttpUserHardware myHttpUserHardware, byte[] byArray) {
            this(myHttpUserHardware, null, byArray, null);
        }

        public UserHardwareRequest(MyHttpUserHardware myHttpUserHardware, String string) {
            this(myHttpUserHardware, null, null, string);
        }
    }

    public record MyHttpSimpleResponse(String message) {
    }
}

