/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchermodules.startscreen;

import java.awt.GraphicsEnvironment;
import javax.imageio.ImageIO;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientGuiPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.client.events.client.ClientProcessPreInvokeMainClassEvent;
import pro.gravit.launcher.modules.LauncherInitContext;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.launchermodules.startscreen.Config;
import pro.gravit.launchermodules.startscreen.ImageDisplay;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class ModuleImpl
extends LauncherModule {
    public static final Version version = new Version(1, 0, 0, 1, Version.Type.LTS);
    public ImageDisplay screen = null;

    public ModuleImpl() {
        super(new LauncherModuleInfo("LauncherStartScreen", version, 0x7FFFFF37, new String[]{"ClientLauncherCore"}));
    }

    @Override
    public void init(LauncherInitContext launcherInitContext) {
        this.registerEvent(this::preInit, ClientPreGuiPhase.class);
        this.registerEvent(this::finish, ClientGuiPhase.class);
        this.registerEvent(this::exitPhase, ClientExitPhase.class);
        this.registerEvent(this::preMainClass, ClientProcessPreInvokeMainClassEvent.class);
    }

    public void preInit(ClientPreGuiPhase clientPreGuiPhase) {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                Config config = new Config();
                this.screen = new ImageDisplay(IOHelper.getResourceURL(config.imageURL), config.faviconURL != null && !config.faviconURL.equalsIgnoreCase("null") ? ImageIO.read(IOHelper.getResourceURL(config.faviconURL)) : null, config);
            }
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
        }
    }

    public void preMainClass(ClientProcessPreInvokeMainClassEvent clientProcessPreInvokeMainClassEvent) {
        if (this.screen != null) {
            try {
                this.screen.close();
                this.screen = null;
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
    }

    public void exitPhase(ClientExitPhase clientExitPhase) {
        if (this.screen != null) {
            try {
                this.screen.close();
                this.screen = null;
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
    }

    public void finish(ClientGuiPhase clientGuiPhase) {
        if (this.screen != null) {
            try {
                this.screen.close();
                this.screen = null;
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
    }
}

