/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.EventLoopGroup;
import pro.gravit.repackage.io.netty.util.NettyRuntime;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultThreadFactory;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutorChooserFactory;
import pro.gravit.repackage.io.netty.util.concurrent.MultithreadEventExecutorGroup;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.eventLoopThreads", NettyRuntime.availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int n, Executor executor, Object ... objectArray) {
        super(n == 0 ? DEFAULT_EVENT_LOOP_THREADS : n, executor, objectArray);
    }

    protected MultithreadEventLoopGroup(int n, ThreadFactory threadFactory, Object ... objectArray) {
        super(n == 0 ? DEFAULT_EVENT_LOOP_THREADS : n, threadFactory, objectArray);
    }

    protected MultithreadEventLoopGroup(int n, Executor executor, EventExecutorChooserFactory eventExecutorChooserFactory, Object ... objectArray) {
        super(n == 0 ? DEFAULT_EVENT_LOOP_THREADS : n, executor, eventExecutorChooserFactory, objectArray);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    protected abstract EventLoop newChild(Executor var1, Object ... var2) throws Exception;

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(ChannelPromise channelPromise) {
        return this.next().register(channelPromise);
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        return this.next().register(channel, channelPromise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

