/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.embedded;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.DefaultChannelPromise;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.EventLoopGroup;
import pro.gravit.repackage.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private long startTime = EmbeddedEventLoop.initialNanoTime();
    private long frozenTimestamp;
    private boolean timeFrozen;
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);

    EmbeddedEventLoop() {
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public void execute(Runnable runnable) {
        this.tasks.add(ObjectUtil.checkNotNull(runnable, "command"));
    }

    void runTasks() {
        Runnable runnable;
        while ((runnable = this.tasks.poll()) != null) {
            runnable.run();
        }
    }

    boolean hasPendingNormalTasks() {
        return !this.tasks.isEmpty();
    }

    long runScheduledTasks() {
        long l = this.getCurrentTimeNanos();
        Runnable runnable;
        while ((runnable = this.pollScheduledTask(l)) != null) {
            runnable.run();
        }
        return this.nextScheduledTaskNano();
    }

    long nextScheduledTask() {
        return this.nextScheduledTaskNano();
    }

    @Override
    protected long getCurrentTimeNanos() {
        if (this.timeFrozen) {
            return this.frozenTimestamp;
        }
        return System.nanoTime() - this.startTime;
    }

    void advanceTimeBy(long l) {
        if (this.timeFrozen) {
            this.frozenTimestamp += l;
        } else {
            this.startTime -= l;
        }
    }

    void freezeTime() {
        if (!this.timeFrozen) {
            this.frozenTimestamp = this.getCurrentTimeNanos();
            this.timeFrozen = true;
        }
    }

    void unfreezeTime() {
        if (this.timeFrozen) {
            this.startTime = System.nanoTime() - this.frozenTimestamp;
            this.timeFrozen = false;
        }
    }

    @Override
    protected void cancelScheduledTasks() {
        super.cancelScheduledTasks();
    }

    @Override
    public Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, this));
    }

    @Override
    public ChannelFuture register(ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(channelPromise, "promise");
        channelPromise.channel().unsafe().register(this, channelPromise);
        return channelPromise;
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        channel.unsafe().register(this, channelPromise);
        return channelPromise;
    }

    @Override
    public boolean inEventLoop() {
        return true;
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return true;
    }
}

