/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelMetadata;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.FileRegion;
import pro.gravit.repackage.io.netty.channel.RecvByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel;
import pro.gravit.repackage.io.netty.channel.socket.ChannelInputShutdownEvent;
import pro.gravit.repackage.io.netty.channel.socket.ChannelInputShutdownReadComplete;
import pro.gravit.repackage.io.netty.channel.socket.SocketChannelConfig;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

public abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';
    private final Runnable flushTask = new Runnable(){

        @Override
        public void run() {
            ((AbstractNioChannel.AbstractNioUnsafe)AbstractNioByteChannel.this.unsafe()).flush0();
        }
    };
    private boolean inputClosedSeenErrorOnRead;

    protected AbstractNioByteChannel(Channel channel, SelectableChannel selectableChannel) {
        super(channel, selectableChannel, 1);
    }

    protected abstract ChannelFuture shutdownInput();

    protected boolean isInputShutdown0() {
        return false;
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioByteUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    final boolean shouldBreakReadReady(ChannelConfig channelConfig) {
        return this.isInputShutdown0() && (this.inputClosedSeenErrorOnRead || !AbstractNioByteChannel.isAllowHalfClosure(channelConfig));
    }

    private static boolean isAllowHalfClosure(ChannelConfig channelConfig) {
        return channelConfig instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    protected final int doWrite0(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        Object object = channelOutboundBuffer.current();
        if (object == null) {
            return 0;
        }
        return this.doWriteInternal(channelOutboundBuffer, channelOutboundBuffer.current());
    }

    private int doWriteInternal(ChannelOutboundBuffer channelOutboundBuffer, Object object) throws Exception {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (!byteBuf.isReadable()) {
                channelOutboundBuffer.remove();
                return 0;
            }
            int n = this.doWriteBytes(byteBuf);
            if (n > 0) {
                channelOutboundBuffer.progress(n);
                if (!byteBuf.isReadable()) {
                    channelOutboundBuffer.remove();
                }
                return 1;
            }
        } else if (object instanceof FileRegion) {
            FileRegion fileRegion = (FileRegion)object;
            if (fileRegion.transferred() >= fileRegion.count()) {
                channelOutboundBuffer.remove();
                return 0;
            }
            long l = this.doWriteFileRegion(fileRegion);
            if (l > 0L) {
                channelOutboundBuffer.progress(l);
                if (fileRegion.transferred() >= fileRegion.count()) {
                    channelOutboundBuffer.remove();
                }
                return 1;
            }
        } else {
            throw new Error();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        Object object;
        int n = this.config().getWriteSpinCount();
        do {
            if ((object = channelOutboundBuffer.current()) != null) continue;
            this.clearOpWrite();
            return;
        } while ((n -= this.doWriteInternal(channelOutboundBuffer, object)) > 0);
        this.incompleteWrite(n < 0);
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (byteBuf.isDirect()) {
                return object;
            }
            return this.newDirectBuffer(byteBuf);
        }
        if (object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected final void incompleteWrite(boolean bl) {
        if (bl) {
            this.setOpWrite();
        } else {
            this.clearOpWrite();
            this.eventLoop().execute(this.flushTask);
        }
    }

    protected abstract long doWriteFileRegion(FileRegion var1) throws Exception;

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1) throws Exception;

    protected final void setOpWrite() {
        SelectionKey selectionKey = this.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n = selectionKey.interestOps();
        if ((n & 4) == 0) {
            selectionKey.interestOps(n | 4);
        }
    }

    protected final void clearOpWrite() {
        SelectionKey selectionKey = this.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n = selectionKey.interestOps();
        if ((n & 4) != 0) {
            selectionKey.interestOps(n & 0xFFFFFFFB);
        }
    }

    protected class NioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        protected NioByteUnsafe() {
            super(AbstractNioByteChannel.this);
        }

        private void closeOnRead(ChannelPipeline channelPipeline) {
            if (!AbstractNioByteChannel.this.isInputShutdown0()) {
                if (AbstractNioByteChannel.isAllowHalfClosure(AbstractNioByteChannel.this.config())) {
                    AbstractNioByteChannel.this.shutdownInput();
                    channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                } else {
                    this.close(this.voidPromise());
                }
            } else if (!AbstractNioByteChannel.this.inputClosedSeenErrorOnRead) {
                AbstractNioByteChannel.this.inputClosedSeenErrorOnRead = true;
                channelPipeline.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl, RecvByteBufAllocator.Handle handle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    AbstractNioByteChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            handle.readComplete();
            channelPipeline.fireChannelReadComplete();
            channelPipeline.fireExceptionCaught(throwable);
            if (bl || throwable instanceof OutOfMemoryError || throwable instanceof IOException) {
                this.closeOnRead(channelPipeline);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void read() {
            ChannelConfig channelConfig = AbstractNioByteChannel.this.config();
            if (AbstractNioByteChannel.this.shouldBreakReadReady(channelConfig)) {
                AbstractNioByteChannel.this.clearReadPending();
                return;
            }
            ChannelPipeline channelPipeline = AbstractNioByteChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = channelConfig.getAllocator();
            RecvByteBufAllocator.Handle handle = this.recvBufAllocHandle();
            handle.reset(channelConfig);
            ByteBuf byteBuf = null;
            boolean bl = false;
            try {
                do {
                    byteBuf = handle.allocate(byteBufAllocator);
                    handle.lastBytesRead(AbstractNioByteChannel.this.doReadBytes(byteBuf));
                    if (handle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        boolean bl2 = bl = handle.lastBytesRead() < 0;
                        if (!bl) break;
                        AbstractNioByteChannel.this.readPending = false;
                        break;
                    }
                    handle.incMessagesRead(1);
                    AbstractNioByteChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                    byteBuf = null;
                } while (handle.continueReading());
                handle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (bl) {
                    this.closeOnRead(channelPipeline);
                }
            }
            catch (Throwable throwable) {
                this.handleReadException(channelPipeline, byteBuf, throwable, bl, handle);
            }
            finally {
                if (!AbstractNioByteChannel.this.readPending && !channelConfig.isAutoRead()) {
                    this.removeReadOp();
                }
            }
        }
    }
}

