/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.unix;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.unix.FileDescriptor;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public abstract class SocketWritableByteChannel
implements WritableByteChannel {
    protected final FileDescriptor fd;

    protected SocketWritableByteChannel(FileDescriptor fileDescriptor) {
        this.fd = ObjectUtil.checkNotNull(fileDescriptor, "fd");
    }

    protected int write(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        return this.fd.write(byteBuffer, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int write(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n = this.write(byteBuffer, n2, byteBuffer.limit());
        } else {
            int n4 = n3 - n2;
            ByteBuf byteBuf = null;
            try {
                Object object;
                if (n4 == 0) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                } else {
                    object = this.alloc();
                    if (object.isDirectBufferPooled()) {
                        byteBuf = object.directBuffer(n4);
                    } else {
                        byteBuf = ByteBufUtil.threadLocalDirectBuffer();
                        if (byteBuf == null) {
                            byteBuf = Unpooled.directBuffer(n4);
                        }
                    }
                }
                byteBuf.writeBytes(byteBuffer.duplicate());
                object = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n4);
                n = this.write((ByteBuffer)object, ((Buffer)object).position(), ((Buffer)object).limit());
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }
        if (n > 0) {
            byteBuffer.position(n2 + n);
        }
        return n;
    }

    @Override
    public final boolean isOpen() {
        return this.fd.isOpen();
    }

    @Override
    public final void close() throws IOException {
        this.fd.close();
    }

    protected abstract ByteBufAllocator alloc();
}

