/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.BrotliEncoderChannel;
import com.aayushatharva.brotli4j.encoder.Encoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.MessageToByteEncoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.BrotliOptions;
import pro.gravit.repackage.io.netty.handler.codec.compression.EncoderUtil;
import pro.gravit.repackage.io.netty.util.AttributeKey;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public final class BrotliEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final AttributeKey<Writer> ATTR = AttributeKey.valueOf("BrotliEncoderWriter");
    private final Encoder.Parameters parameters;
    private final boolean isSharable;
    private Writer writer;

    public BrotliEncoder() {
        this(BrotliOptions.DEFAULT);
    }

    public BrotliEncoder(BrotliOptions brotliOptions) {
        this(brotliOptions.parameters());
    }

    public BrotliEncoder(Encoder.Parameters parameters) {
        this(parameters, true);
    }

    public BrotliEncoder(Encoder.Parameters parameters, boolean bl) {
        this.parameters = ObjectUtil.checkNotNull(parameters, "Parameters");
        this.isSharable = bl;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        Writer writer = new Writer(this.parameters, channelHandlerContext);
        if (this.isSharable) {
            channelHandlerContext.channel().attr(ATTR).set(writer);
        } else {
            this.writer = writer;
        }
        super.handlerAdded(channelHandlerContext);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.finish(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) throws Exception {
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl) throws Exception {
        if (!byteBuf.isReadable()) {
            return Unpooled.EMPTY_BUFFER;
        }
        Writer writer = this.isSharable ? channelHandlerContext.channel().attr(ATTR).get() : this.writer;
        if (writer == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        writer.encode(byteBuf, bl);
        return writer.writableBuffer;
    }

    @Override
    public boolean isSharable() {
        return this.isSharable;
    }

    public void finish(ChannelHandlerContext channelHandlerContext) throws IOException {
        this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
    }

    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws IOException {
        Writer writer = this.isSharable ? (Writer)channelHandlerContext.channel().attr(ATTR).getAndSet(null) : this.writer;
        if (writer != null) {
            writer.close();
            this.writer = null;
        }
        return channelPromise;
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        EncoderUtil.closeAfterFinishEncode(channelHandlerContext, channelFuture, channelPromise);
    }

    private static final class Writer
    implements WritableByteChannel {
        private ByteBuf writableBuffer;
        private final BrotliEncoderChannel brotliEncoderChannel;
        private final ChannelHandlerContext ctx;
        private boolean isClosed;

        private Writer(Encoder.Parameters parameters, ChannelHandlerContext channelHandlerContext) throws IOException {
            this.brotliEncoderChannel = new BrotliEncoderChannel((WritableByteChannel)this, parameters);
            this.ctx = channelHandlerContext;
        }

        private void encode(ByteBuf byteBuf, boolean bl) throws Exception {
            try {
                this.allocate(bl);
                this.brotliEncoderChannel.write(byteBuf.nioBuffer());
                this.brotliEncoderChannel.flush();
            }
            catch (Exception exception) {
                ReferenceCountUtil.release(byteBuf);
                throw exception;
            }
        }

        private void allocate(boolean bl) {
            this.writableBuffer = bl ? this.ctx.alloc().ioBuffer() : this.ctx.alloc().buffer();
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.writableBuffer.writeBytes(byteBuffer).readableBytes();
        }

        @Override
        public boolean isOpen() {
            return !this.isClosed;
        }

        @Override
        public void close() {
            final ChannelPromise channelPromise = this.ctx.newPromise();
            this.ctx.executor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Writer.this.finish(channelPromise);
                    }
                    catch (IOException iOException) {
                        channelPromise.setFailure(new IllegalStateException("Failed to finish encoding", iOException));
                    }
                }
            });
        }

        public void finish(ChannelPromise channelPromise) throws IOException {
            if (!this.isClosed) {
                this.allocate(true);
                try {
                    this.brotliEncoderChannel.close();
                    this.isClosed = true;
                }
                catch (Exception exception) {
                    channelPromise.setFailure(exception);
                    ReferenceCountUtil.release(this.writableBuffer);
                    return;
                }
                this.ctx.writeAndFlush(this.writableBuffer, channelPromise);
            }
        }
    }
}

