/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.IOException;
import java.nio.charset.Charset;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpConstants;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.AbstractMixedHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.Attribute;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.DiskAttribute;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.DiskFileUpload;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.MemoryAttribute;

public class MixedAttribute
extends AbstractMixedHttpData<Attribute>
implements Attribute {
    public MixedAttribute(String string, long l) {
        this(string, l, HttpConstants.DEFAULT_CHARSET);
    }

    public MixedAttribute(String string, long l, long l2) {
        this(string, l, l2, HttpConstants.DEFAULT_CHARSET);
    }

    public MixedAttribute(String string, long l, Charset charset) {
        this(string, l, charset, DiskAttribute.baseDirectory, DiskAttribute.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String string, long l, Charset charset, String string2, boolean bl) {
        this(string, 0L, l, charset, string2, bl);
    }

    public MixedAttribute(String string, long l, long l2, Charset charset) {
        this(string, l, l2, charset, DiskAttribute.baseDirectory, DiskAttribute.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String string, long l, long l2, Charset charset, String string2, boolean bl) {
        super(l2, string2, bl, new MemoryAttribute(string, l, charset));
    }

    public MixedAttribute(String string, String string2, long l) {
        this(string, string2, l, HttpConstants.DEFAULT_CHARSET, DiskAttribute.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String string, String string2, long l, Charset charset) {
        this(string, string2, l, charset, DiskAttribute.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
    }

    private static Attribute makeInitialAttributeFromValue(String string, String string2, long l, Charset charset, String string3, boolean bl) {
        if ((long)string2.length() > l) {
            try {
                return new DiskAttribute(string, string2, charset, string3, bl);
            }
            catch (IOException iOException) {
                try {
                    return new MemoryAttribute(string, string2, charset);
                }
                catch (IOException iOException2) {
                    throw new IllegalArgumentException(iOException);
                }
            }
        }
        try {
            return new MemoryAttribute(string, string2, charset);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    public MixedAttribute(String string, String string2, long l, Charset charset, String string3, boolean bl) {
        super(l, string3, bl, MixedAttribute.makeInitialAttributeFromValue(string, string2, l, charset, string3, bl));
    }

    @Override
    public String getValue() throws IOException {
        return ((Attribute)this.wrapped).getValue();
    }

    @Override
    public void setValue(String string) throws IOException {
        ((Attribute)this.wrapped).setValue(string);
    }

    @Override
    Attribute makeDiskData() {
        DiskAttribute diskAttribute = new DiskAttribute(this.getName(), this.definedLength(), this.baseDir, this.deleteOnExit);
        diskAttribute.setMaxSize(this.getMaxSize());
        return diskAttribute;
    }

    @Override
    public Attribute copy() {
        return (Attribute)super.copy();
    }

    @Override
    public Attribute duplicate() {
        return (Attribute)super.duplicate();
    }

    @Override
    public Attribute replace(ByteBuf byteBuf) {
        return (Attribute)super.replace(byteBuf);
    }

    @Override
    public Attribute retain() {
        return (Attribute)super.retain();
    }

    @Override
    public Attribute retain(int n) {
        return (Attribute)super.retain(n);
    }

    @Override
    public Attribute retainedDuplicate() {
        return (Attribute)super.retainedDuplicate();
    }

    @Override
    public Attribute touch() {
        return (Attribute)super.touch();
    }

    @Override
    public Attribute touch(Object object) {
        return (Attribute)super.touch(object);
    }
}

