/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.Utf8Validator;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class Utf8FrameValidator
extends ChannelInboundHandlerAdapter {
    private final boolean closeOnProtocolViolation;
    private int fragmentedFramesCount;
    private Utf8Validator utf8Validator;

    public Utf8FrameValidator() {
        this(true);
    }

    public Utf8FrameValidator(boolean bl) {
        this.closeOnProtocolViolation = bl;
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof WebSocketFrame) {
            WebSocketFrame webSocketFrame = (WebSocketFrame)object;
            try {
                if (((WebSocketFrame)object).isFinalFragment()) {
                    if (!(webSocketFrame instanceof PingWebSocketFrame)) {
                        this.fragmentedFramesCount = 0;
                        if (webSocketFrame instanceof TextWebSocketFrame || this.utf8Validator != null && this.utf8Validator.isChecking()) {
                            this.checkUTF8String(webSocketFrame.content());
                            this.utf8Validator.finish();
                        }
                    }
                } else {
                    if (this.fragmentedFramesCount == 0) {
                        if (webSocketFrame instanceof TextWebSocketFrame) {
                            this.checkUTF8String(webSocketFrame.content());
                        }
                    } else if (this.utf8Validator != null && this.utf8Validator.isChecking()) {
                        this.checkUTF8String(webSocketFrame.content());
                    }
                    ++this.fragmentedFramesCount;
                }
            }
            catch (CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
                this.protocolViolation(channelHandlerContext, webSocketFrame, corruptedWebSocketFrameException);
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    private void checkUTF8String(ByteBuf byteBuf) {
        if (this.utf8Validator == null) {
            this.utf8Validator = new Utf8Validator();
        }
        this.utf8Validator.check(byteBuf);
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
        webSocketFrame.release();
        if (this.closeOnProtocolViolation && channelHandlerContext.channel().isOpen()) {
            WebSocketCloseStatus webSocketCloseStatus = corruptedWebSocketFrameException.closeStatus();
            String string = corruptedWebSocketFrameException.getMessage();
            if (string == null) {
                string = webSocketCloseStatus.reasonText();
            }
            CloseWebSocketFrame closeWebSocketFrame = new CloseWebSocketFrame(webSocketCloseStatus.code(), string);
            channelHandlerContext.writeAndFlush(closeWebSocketFrame).addListener(ChannelFutureListener.CLOSE);
        }
        throw corruptedWebSocketFrameException;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        super.exceptionCaught(channelHandlerContext, throwable);
    }
}

