/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class WebSocketServerProtocolConfig {
    static final long DEFAULT_HANDSHAKE_TIMEOUT_MILLIS = 10000L;
    private final String websocketPath;
    private final String subprotocols;
    private final boolean checkStartsWith;
    private final long handshakeTimeoutMillis;
    private final long forceCloseTimeoutMillis;
    private final boolean handleCloseFrames;
    private final WebSocketCloseStatus sendCloseFrame;
    private final boolean dropPongFrames;
    private final WebSocketDecoderConfig decoderConfig;

    private WebSocketServerProtocolConfig(String string, String string2, boolean bl, long l, long l2, boolean bl2, WebSocketCloseStatus webSocketCloseStatus, boolean bl3, WebSocketDecoderConfig webSocketDecoderConfig) {
        this.websocketPath = string;
        this.subprotocols = string2;
        this.checkStartsWith = bl;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive(l, "handshakeTimeoutMillis");
        this.forceCloseTimeoutMillis = l2;
        this.handleCloseFrames = bl2;
        this.sendCloseFrame = webSocketCloseStatus;
        this.dropPongFrames = bl3;
        this.decoderConfig = webSocketDecoderConfig == null ? WebSocketDecoderConfig.DEFAULT : webSocketDecoderConfig;
    }

    public String websocketPath() {
        return this.websocketPath;
    }

    public String subprotocols() {
        return this.subprotocols;
    }

    public boolean checkStartsWith() {
        return this.checkStartsWith;
    }

    public long handshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    public boolean handleCloseFrames() {
        return this.handleCloseFrames;
    }

    public WebSocketCloseStatus sendCloseFrame() {
        return this.sendCloseFrame;
    }

    public boolean dropPongFrames() {
        return this.dropPongFrames;
    }

    public WebSocketDecoderConfig decoderConfig() {
        return this.decoderConfig;
    }

    public String toString() {
        return "WebSocketServerProtocolConfig {websocketPath=" + this.websocketPath + ", subprotocols=" + this.subprotocols + ", checkStartsWith=" + this.checkStartsWith + ", handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", forceCloseTimeoutMillis=" + this.forceCloseTimeoutMillis + ", handleCloseFrames=" + this.handleCloseFrames + ", sendCloseFrame=" + this.sendCloseFrame + ", dropPongFrames=" + this.dropPongFrames + ", decoderConfig=" + this.decoderConfig + "}";
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder("/", null, false, 10000L, 0L, true, WebSocketCloseStatus.NORMAL_CLOSURE, true, WebSocketDecoderConfig.DEFAULT);
    }

    public static final class Builder {
        private String websocketPath;
        private String subprotocols;
        private boolean checkStartsWith;
        private long handshakeTimeoutMillis;
        private long forceCloseTimeoutMillis;
        private boolean handleCloseFrames;
        private WebSocketCloseStatus sendCloseFrame;
        private boolean dropPongFrames;
        private WebSocketDecoderConfig decoderConfig;
        private WebSocketDecoderConfig.Builder decoderConfigBuilder;

        private Builder(WebSocketServerProtocolConfig webSocketServerProtocolConfig) {
            this(ObjectUtil.checkNotNull(webSocketServerProtocolConfig, "serverConfig").websocketPath(), webSocketServerProtocolConfig.subprotocols(), webSocketServerProtocolConfig.checkStartsWith(), webSocketServerProtocolConfig.handshakeTimeoutMillis(), webSocketServerProtocolConfig.forceCloseTimeoutMillis(), webSocketServerProtocolConfig.handleCloseFrames(), webSocketServerProtocolConfig.sendCloseFrame(), webSocketServerProtocolConfig.dropPongFrames(), webSocketServerProtocolConfig.decoderConfig());
        }

        private Builder(String string, String string2, boolean bl, long l, long l2, boolean bl2, WebSocketCloseStatus webSocketCloseStatus, boolean bl3, WebSocketDecoderConfig webSocketDecoderConfig) {
            this.websocketPath = string;
            this.subprotocols = string2;
            this.checkStartsWith = bl;
            this.handshakeTimeoutMillis = l;
            this.forceCloseTimeoutMillis = l2;
            this.handleCloseFrames = bl2;
            this.sendCloseFrame = webSocketCloseStatus;
            this.dropPongFrames = bl3;
            this.decoderConfig = webSocketDecoderConfig;
        }

        public Builder websocketPath(String string) {
            this.websocketPath = string;
            return this;
        }

        public Builder subprotocols(String string) {
            this.subprotocols = string;
            return this;
        }

        public Builder checkStartsWith(boolean bl) {
            this.checkStartsWith = bl;
            return this;
        }

        public Builder handshakeTimeoutMillis(long l) {
            this.handshakeTimeoutMillis = l;
            return this;
        }

        public Builder forceCloseTimeoutMillis(long l) {
            this.forceCloseTimeoutMillis = l;
            return this;
        }

        public Builder handleCloseFrames(boolean bl) {
            this.handleCloseFrames = bl;
            return this;
        }

        public Builder sendCloseFrame(WebSocketCloseStatus webSocketCloseStatus) {
            this.sendCloseFrame = webSocketCloseStatus;
            return this;
        }

        public Builder dropPongFrames(boolean bl) {
            this.dropPongFrames = bl;
            return this;
        }

        public Builder decoderConfig(WebSocketDecoderConfig webSocketDecoderConfig) {
            this.decoderConfig = webSocketDecoderConfig == null ? WebSocketDecoderConfig.DEFAULT : webSocketDecoderConfig;
            this.decoderConfigBuilder = null;
            return this;
        }

        private WebSocketDecoderConfig.Builder decoderConfigBuilder() {
            if (this.decoderConfigBuilder == null) {
                this.decoderConfigBuilder = this.decoderConfig.toBuilder();
            }
            return this.decoderConfigBuilder;
        }

        public Builder maxFramePayloadLength(int n) {
            this.decoderConfigBuilder().maxFramePayloadLength(n);
            return this;
        }

        public Builder expectMaskedFrames(boolean bl) {
            this.decoderConfigBuilder().expectMaskedFrames(bl);
            return this;
        }

        public Builder allowMaskMismatch(boolean bl) {
            this.decoderConfigBuilder().allowMaskMismatch(bl);
            return this;
        }

        public Builder allowExtensions(boolean bl) {
            this.decoderConfigBuilder().allowExtensions(bl);
            return this;
        }

        public Builder closeOnProtocolViolation(boolean bl) {
            this.decoderConfigBuilder().closeOnProtocolViolation(bl);
            return this;
        }

        public Builder withUTF8Validator(boolean bl) {
            this.decoderConfigBuilder().withUTF8Validator(bl);
            return this;
        }

        public WebSocketServerProtocolConfig build() {
            return new WebSocketServerProtocolConfig(this.websocketPath, this.subprotocols, this.checkStartsWith, this.handshakeTimeoutMillis, this.forceCloseTimeoutMillis, this.handleCloseFrames, this.sendCloseFrame, this.dropPongFrames, this.decoderConfigBuilder == null ? this.decoderConfig : this.decoderConfigBuilder.build());
        }
    }
}

