/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.rtsp;

import java.util.regex.Pattern;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessage;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.rtsp.RtspHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.rtsp.RtspMethods;
import pro.gravit.repackage.io.netty.handler.codec.rtsp.RtspVersions;

public class RtspDecoder
extends HttpObjectDecoder {
    private static final HttpResponseStatus UNKNOWN_STATUS = new HttpResponseStatus(999, "Unknown");
    private boolean isDecodingRequest;
    private static final Pattern versionPattern = Pattern.compile("RTSP/\\d\\.\\d");
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 8192;

    public RtspDecoder() {
        this(4096, 8192, 8192);
    }

    public RtspDecoder(int n, int n2, int n3) {
        super(n, n2, n3 * 2, false);
    }

    public RtspDecoder(int n, int n2, int n3, boolean bl) {
        super(n, n2, n3 * 2, false, bl);
    }

    @Override
    protected HttpMessage createMessage(String[] stringArray) throws Exception {
        if (versionPattern.matcher(stringArray[0]).matches()) {
            this.isDecodingRequest = false;
            return new DefaultHttpResponse(RtspVersions.valueOf(stringArray[0]), new HttpResponseStatus(Integer.parseInt(stringArray[1]), stringArray[2]), this.validateHeaders);
        }
        this.isDecodingRequest = true;
        return new DefaultHttpRequest(RtspVersions.valueOf(stringArray[2]), RtspMethods.valueOf(stringArray[0]), stringArray[1], this.validateHeaders);
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        return super.isContentAlwaysEmpty(httpMessage) || !httpMessage.headers().contains(RtspHeaderNames.CONTENT_LENGTH);
    }

    @Override
    protected HttpMessage createInvalidMessage() {
        if (this.isDecodingRequest) {
            return new DefaultFullHttpRequest(RtspVersions.RTSP_1_0, RtspMethods.OPTIONS, "/bad-request", this.validateHeaders);
        }
        return new DefaultFullHttpResponse(RtspVersions.RTSP_1_0, UNKNOWN_STATUS, this.validateHeaders);
    }

    @Override
    protected boolean isDecodingRequest() {
        return this.isDecodingRequest;
    }
}

