/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.AbstractCoalescingBufferQueue;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelOption;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.unix.UnixChannel;
import pro.gravit.repackage.io.netty.handler.codec.ByteToMessageDecoder;
import pro.gravit.repackage.io.netty.handler.codec.DecoderException;
import pro.gravit.repackage.io.netty.handler.codec.UnsupportedMessageTypeException;
import pro.gravit.repackage.io.netty.handler.ssl.ApplicationProtocolAccessor;
import pro.gravit.repackage.io.netty.handler.ssl.AsyncRunnable;
import pro.gravit.repackage.io.netty.handler.ssl.ConscryptAlpnSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.NotSslRecordException;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.SslCloseCompletionEvent;
import pro.gravit.repackage.io.netty.handler.ssl.SslClosedEngineException;
import pro.gravit.repackage.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import pro.gravit.repackage.io.netty.handler.ssl.SslHandshakeTimeoutException;
import pro.gravit.repackage.io.netty.handler.ssl.SslUtils;
import pro.gravit.repackage.io.netty.handler.ssl.StacklessSSLHandshakeException;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.FutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.ImmediateExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseNotifier;
import pro.gravit.repackage.io.netty.util.concurrent.ScheduledFuture;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.ThrowableUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final int STATE_SENT_FIRST_MESSAGE = 1;
    private static final int STATE_FLUSHED_BEFORE_HANDSHAKE = 2;
    private static final int STATE_READ_DURING_HANDSHAKE = 4;
    private static final int STATE_HANDSHAKE_STARTED = 8;
    private static final int STATE_NEEDS_FLUSH = 16;
    private static final int STATE_OUTBOUND_CLOSED = 32;
    private static final int STATE_CLOSE_NOTIFY = 64;
    private static final int STATE_PROCESS_TASK = 128;
    private static final int STATE_FIRE_CHANNEL_READ = 256;
    private static final int STATE_UNWRAP_REENTRY = 512;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslEngineType engineType;
    private final Executor delegatedTaskExecutor;
    private final boolean jdkCompatibilityMode;
    private final ByteBuffer[] singleBuffer = new ByteBuffer[1];
    private final boolean startTls;
    private final SslTasksRunner sslTaskRunnerForUnwrap = new SslTasksRunner(true);
    private final SslTasksRunner sslTaskRunner = new SslTasksRunner(false);
    private SslHandlerCoalescingBufferQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new LazyChannelPromise();
    private final LazyChannelPromise sslClosePromise = new LazyChannelPromise();
    private int packetLength;
    private short state;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyFlushTimeoutMillis = 3000L;
    private volatile long closeNotifyReadTimeoutMillis;
    volatile int wrapDataSize = 16384;

    public SslHandler(SSLEngine sSLEngine) {
        this(sSLEngine, false);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl) {
        this(sSLEngine, bl, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine sSLEngine, Executor executor) {
        this(sSLEngine, false, executor);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl, Executor executor) {
        this.engine = ObjectUtil.checkNotNull(sSLEngine, "engine");
        this.delegatedTaskExecutor = ObjectUtil.checkNotNull(executor, "delegatedTaskExecutor");
        this.engineType = SslEngineType.forEngine(sSLEngine);
        this.startTls = bl;
        this.jdkCompatibilityMode = this.engineType.jdkCompatibilityMode(sSLEngine);
        this.setCumulator(this.engineType.cumulator);
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(timeUnit, "unit");
        this.setHandshakeTimeoutMillis(timeUnit.toMillis(l));
    }

    public void setHandshakeTimeoutMillis(long l) {
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero(l, "handshakeTimeoutMillis");
    }

    public final void setWrapDataSize(int n) {
        this.wrapDataSize = n;
    }

    @Deprecated
    public long getCloseNotifyTimeoutMillis() {
        return this.getCloseNotifyFlushTimeoutMillis();
    }

    @Deprecated
    public void setCloseNotifyTimeout(long l, TimeUnit timeUnit) {
        this.setCloseNotifyFlushTimeout(l, timeUnit);
    }

    @Deprecated
    public void setCloseNotifyTimeoutMillis(long l) {
        this.setCloseNotifyFlushTimeoutMillis(l);
    }

    public final long getCloseNotifyFlushTimeoutMillis() {
        return this.closeNotifyFlushTimeoutMillis;
    }

    public final void setCloseNotifyFlushTimeout(long l, TimeUnit timeUnit) {
        this.setCloseNotifyFlushTimeoutMillis(timeUnit.toMillis(l));
    }

    public final void setCloseNotifyFlushTimeoutMillis(long l) {
        this.closeNotifyFlushTimeoutMillis = ObjectUtil.checkPositiveOrZero(l, "closeNotifyFlushTimeoutMillis");
    }

    public final long getCloseNotifyReadTimeoutMillis() {
        return this.closeNotifyReadTimeoutMillis;
    }

    public final void setCloseNotifyReadTimeout(long l, TimeUnit timeUnit) {
        this.setCloseNotifyReadTimeoutMillis(timeUnit.toMillis(l));
    }

    public final void setCloseNotifyReadTimeoutMillis(long l) {
        this.closeNotifyReadTimeoutMillis = ObjectUtil.checkPositiveOrZero(l, "closeNotifyReadTimeoutMillis");
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public String applicationProtocol() {
        SSLEngine sSLEngine = this.engine();
        if (!(sSLEngine instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)((Object)sSLEngine)).getNegotiatedApplicationProtocol();
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise;
    }

    @Deprecated
    public ChannelFuture close() {
        return this.closeOutbound();
    }

    @Deprecated
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.closeOutbound(channelPromise);
    }

    public ChannelFuture closeOutbound() {
        return this.closeOutbound(this.ctx.newPromise());
    }

    public ChannelFuture closeOutbound(final ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext.executor().inEventLoop()) {
            this.closeOutbound0(channelPromise);
        } else {
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.closeOutbound0(channelPromise);
                }
            });
        }
        return channelPromise;
    }

    private void closeOutbound0(ChannelPromise channelPromise) {
        block2: {
            this.setState(32);
            this.engine.closeOutbound();
            try {
                this.flush(this.ctx, channelPromise);
            }
            catch (Exception exception) {
                if (channelPromise.tryFailure(exception)) break block2;
                logger.warn("{} flush() raised a masked exception.", (Object)this.ctx.channel(), (Object)exception);
            }
        }
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslClosePromise;
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            if (this.pendingUnencryptedWrites != null && !this.pendingUnencryptedWrites.isEmpty()) {
                this.pendingUnencryptedWrites.releaseAndFailAll(channelHandlerContext, new ChannelException("Pending write on removal of SslHandler"));
            }
            this.pendingUnencryptedWrites = null;
            SSLException sSLException = null;
            if (!this.handshakePromise.isDone() && this.handshakePromise.tryFailure(sSLException = new SSLHandshakeException("SslHandler removed before handshake completed"))) {
                channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(sSLException));
            }
            if (!this.sslClosePromise.isDone()) {
                if (sSLException == null) {
                    sSLException = new SSLException("SslHandler removed before SSLEngine was closed");
                }
                this.notifyClosePromise(sSLException);
            }
        }
        finally {
            ReferenceCountUtil.release(this.engine);
        }
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, true);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, false);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.handshakePromise.isDone()) {
            this.setState(4);
        }
        channelHandlerContext.read();
    }

    private static IllegalStateException newPendingWritesNullException() {
        return new IllegalStateException("pendingUnencryptedWrites is null, handlerRemoved0 called?");
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (!(object instanceof ByteBuf)) {
            UnsupportedMessageTypeException unsupportedMessageTypeException = new UnsupportedMessageTypeException(object, ByteBuf.class);
            ReferenceCountUtil.safeRelease(object);
            channelPromise.setFailure(unsupportedMessageTypeException);
        } else if (this.pendingUnencryptedWrites == null) {
            ReferenceCountUtil.safeRelease(object);
            channelPromise.setFailure(SslHandler.newPendingWritesNullException());
        } else {
            this.pendingUnencryptedWrites.add((ByteBuf)object, channelPromise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.startTls && !this.isStateSet(1)) {
            this.setState(1);
            this.pendingUnencryptedWrites.writeAndRemoveAll(channelHandlerContext);
            this.forceFlush(channelHandlerContext);
            this.startHandshakeProcessing(true);
            return;
        }
        if (this.isStateSet(128)) {
            return;
        }
        try {
            this.wrapAndFlush(channelHandlerContext);
        }
        catch (Throwable throwable) {
            this.setHandshakeFailure(channelHandlerContext, throwable);
            PlatformDependent.throwException(throwable);
        }
    }

    private void wrapAndFlush(ChannelHandlerContext channelHandlerContext) throws SSLException {
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelHandlerContext.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.setState(2);
        }
        try {
            this.wrap(channelHandlerContext, false);
        }
        finally {
            this.forceFlush(channelHandlerContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrap(ChannelHandlerContext channelHandlerContext, boolean bl) throws SSLException {
        block25: {
            ReferenceCounted referenceCounted = null;
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            try {
                int n = this.wrapDataSize;
                block11: while (!channelHandlerContext.isRemoved()) {
                    Object object;
                    ByteBuf byteBuf;
                    ChannelPromise channelPromise = channelHandlerContext.newPromise();
                    ByteBuf byteBuf2 = byteBuf = n > 0 ? this.pendingUnencryptedWrites.remove(byteBufAllocator, n, channelPromise) : this.pendingUnencryptedWrites.removeFirst(channelPromise);
                    if (byteBuf == null) {
                        break;
                    }
                    if (referenceCounted == null) {
                        referenceCounted = this.allocateOutNetBuf(channelHandlerContext, byteBuf.readableBytes(), byteBuf.nioBufferCount());
                    }
                    SSLEngineResult sSLEngineResult = this.wrap(byteBufAllocator, this.engine, byteBuf, (ByteBuf)referenceCounted);
                    if (byteBuf.isReadable()) {
                        this.pendingUnencryptedWrites.addFirst(byteBuf, channelPromise);
                        channelPromise = null;
                    } else {
                        byteBuf.release();
                    }
                    if (((ByteBuf)referenceCounted).isReadable()) {
                        object = referenceCounted;
                        referenceCounted = null;
                        if (channelPromise != null) {
                            channelHandlerContext.write(object, channelPromise);
                        } else {
                            channelHandlerContext.write(object);
                        }
                    } else if (channelPromise != null) {
                        channelHandlerContext.write(Unpooled.EMPTY_BUFFER, channelPromise);
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                        object = this.handshakePromise.cause();
                        if (object == null && (object = this.sslClosePromise.cause()) == null) {
                            object = new SslClosedEngineException("SSLEngine closed already");
                        }
                        this.pendingUnencryptedWrites.releaseAndFailAll(channelHandlerContext, (Throwable)object);
                        return;
                    }
                    switch (sSLEngineResult.getHandshakeStatus()) {
                        case NEED_TASK: {
                            if (this.runDelegatedTasks(bl)) continue block11;
                            break block25;
                        }
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            this.setHandshakeSuccess();
                            break;
                        }
                        case NEED_WRAP: {
                            if (sSLEngineResult.bytesProduced() <= 0 || !this.pendingUnencryptedWrites.isEmpty()) continue block11;
                            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER);
                            break;
                        }
                        case NEED_UNWRAP: {
                            this.readIfNeeded(channelHandlerContext);
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()));
                        }
                    }
                }
            }
            finally {
                if (referenceCounted != null) {
                    referenceCounted.release();
                }
                if (bl) {
                    this.setState(16);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wrapNonAppData(final ChannelHandlerContext channelHandlerContext, boolean bl) throws SSLException {
        block23: {
            ReferenceCounted referenceCounted = null;
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            try {
                while (!channelHandlerContext.isRemoved()) {
                    SSLEngineResult sSLEngineResult;
                    if (referenceCounted == null) {
                        referenceCounted = this.allocateOutNetBuf(channelHandlerContext, 2048, 1);
                    }
                    if ((sSLEngineResult = this.wrap(byteBufAllocator, this.engine, Unpooled.EMPTY_BUFFER, (ByteBuf)referenceCounted)).bytesProduced() > 0) {
                        channelHandlerContext.write(referenceCounted).addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture channelFuture) {
                                Throwable throwable = channelFuture.cause();
                                if (throwable != null) {
                                    SslHandler.this.setHandshakeFailureTransportFailure(channelHandlerContext, throwable);
                                }
                            }
                        });
                        if (bl) {
                            this.setState(16);
                        }
                        referenceCounted = null;
                    }
                    SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    switch (handshakeStatus) {
                        case FINISHED: {
                            if (this.setHandshakeSuccess() && bl && !this.pendingUnencryptedWrites.isEmpty()) {
                                this.wrap(channelHandlerContext, true);
                            }
                            boolean bl2 = false;
                            return bl2;
                        }
                        case NEED_TASK: {
                            if (this.runDelegatedTasks(bl)) break;
                            break block23;
                        }
                        case NEED_UNWRAP: {
                            if (!bl && this.unwrapNonAppData(channelHandlerContext) > 0) break;
                            boolean bl3 = false;
                            return bl3;
                        }
                        case NEED_WRAP: {
                            break;
                        }
                        case NOT_HANDSHAKING: {
                            if (this.setHandshakeSuccess() && bl && !this.pendingUnencryptedWrites.isEmpty()) {
                                this.wrap(channelHandlerContext, true);
                            }
                            if (!bl) {
                                this.unwrapNonAppData(channelHandlerContext);
                            }
                            boolean bl4 = true;
                            return bl4;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()));
                        }
                    }
                    if (sSLEngineResult.bytesProduced() == 0 && handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    } else if (sSLEngineResult.bytesConsumed() != 0 || sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
                    break;
                }
            }
            finally {
                if (referenceCounted != null) {
                    referenceCounted.release();
                }
            }
        }
        return false;
    }

    private SSLEngineResult wrap(ByteBufAllocator byteBufAllocator, SSLEngine sSLEngine, ByteBuf byteBuf, ByteBuf byteBuf2) throws SSLException {
        ReferenceCounted referenceCounted = null;
        try {
            ByteBuffer[] byteBufferArray;
            int n = byteBuf.readerIndex();
            int n2 = byteBuf.readableBytes();
            if (byteBuf.isDirect() || !this.engineType.wantsDirectBuffer) {
                if (!(byteBuf instanceof CompositeByteBuf) && byteBuf.nioBufferCount() == 1) {
                    byteBufferArray = this.singleBuffer;
                    byteBufferArray[0] = byteBuf.internalNioBuffer(n, n2);
                } else {
                    byteBufferArray = byteBuf.nioBuffers();
                }
            } else {
                referenceCounted = byteBufAllocator.directBuffer(n2);
                ((ByteBuf)referenceCounted).writeBytes(byteBuf, n, n2);
                byteBufferArray = this.singleBuffer;
                byteBufferArray[0] = ((ByteBuf)referenceCounted).internalNioBuffer(((ByteBuf)referenceCounted).readerIndex(), n2);
            }
            while (true) {
                ByteBuffer byteBuffer = byteBuf2.nioBuffer(byteBuf2.writerIndex(), byteBuf2.writableBytes());
                SSLEngineResult sSLEngineResult = sSLEngine.wrap(byteBufferArray, byteBuffer);
                byteBuf.skipBytes(sSLEngineResult.bytesConsumed());
                byteBuf2.writerIndex(byteBuf2.writerIndex() + sSLEngineResult.bytesProduced());
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    SSLEngineResult sSLEngineResult2 = sSLEngineResult;
                    return sSLEngineResult2;
                }
                byteBuf2.ensureWritable(sSLEngine.getSession().getPacketBufferSize());
            }
        }
        finally {
            this.singleBuffer[0] = null;
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        block3: {
            boolean bl = this.handshakePromise.cause() != null;
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (this.isStateSet(8) && !this.handshakePromise.isDone()) {
                ThrowableUtil.addSuppressed((Throwable)closedChannelException, StacklessSSLHandshakeException.newInstance("Connection closed while SSL/TLS handshake was in progress", SslHandler.class, "channelInactive"));
            }
            this.setHandshakeFailure(channelHandlerContext, closedChannelException, !this.isStateSet(32), this.isStateSet(8), false);
            this.notifyClosePromise(closedChannelException);
            try {
                super.channelInactive(channelHandlerContext);
            }
            catch (DecoderException decoderException) {
                if (bl && decoderException.getCause() instanceof SSLException) break block3;
                throw decoderException;
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (this.ignoreException(throwable)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)channelHandlerContext.channel(), (Object)throwable);
            }
            if (channelHandlerContext.channel().isActive()) {
                channelHandlerContext.close();
            }
        } else {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private boolean ignoreException(Throwable throwable) {
        if (!(throwable instanceof SSLException) && throwable instanceof IOException && this.sslClosePromise.isDone()) {
            StackTraceElement[] stackTraceElementArray;
            String string = throwable.getMessage();
            if (string != null && IGNORABLE_ERROR_MESSAGE.matcher(string).matches()) {
                return true;
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                String string2 = stackTraceElement.getClassName();
                String string3 = stackTraceElement.getMethodName();
                if (string2.startsWith("pro.gravit.repackage.io.netty.") || !"read".equals(string3)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(string2).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = PlatformDependent.getClassLoader(this.getClass()).loadClass(string2);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                }
                catch (Throwable throwable2) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Unexpected exception while loading class {} classname {}", this.getClass(), string2, throwable2);
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        return SslUtils.getEncryptedPacketLength(byteBuf, byteBuf.readerIndex()) != -2;
    }

    private void decodeJdkCompatible(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws NotSslRecordException {
        int n;
        int n2 = this.packetLength;
        if (n2 > 0) {
            if (byteBuf.readableBytes() < n2) {
                return;
            }
        } else {
            n = byteBuf.readableBytes();
            if (n < 5) {
                return;
            }
            n2 = SslUtils.getEncryptedPacketLength(byteBuf, byteBuf.readerIndex());
            if (n2 == -2) {
                NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(byteBuf));
                byteBuf.skipBytes(byteBuf.readableBytes());
                this.setHandshakeFailure(channelHandlerContext, notSslRecordException);
                throw notSslRecordException;
            }
            assert (n2 > 0);
            if (n2 > n) {
                this.packetLength = n2;
                return;
            }
        }
        this.packetLength = 0;
        try {
            n = this.unwrap(channelHandlerContext, byteBuf, n2);
            assert (n == n2 || this.engine.isInboundDone()) : "we feed the SSLEngine a packets worth of data: " + n2 + " but it only consumed: " + n;
        }
        catch (Throwable throwable) {
            this.handleUnwrapThrowable(channelHandlerContext, throwable);
        }
    }

    private void decodeNonJdkCompatible(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        try {
            this.unwrap(channelHandlerContext, byteBuf, byteBuf.readableBytes());
        }
        catch (Throwable throwable) {
            this.handleUnwrapThrowable(channelHandlerContext, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnwrapThrowable(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        try {
            if (this.handshakePromise.tryFailure(throwable)) {
                channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
            }
            if (this.pendingUnencryptedWrites != null) {
                this.wrapAndFlush(channelHandlerContext);
            }
        }
        catch (SSLException sSLException) {
            logger.debug("SSLException during trying to call SSLEngine.wrap(...) because of an previous SSLException, ignoring...", sSLException);
        }
        finally {
            this.setHandshakeFailure(channelHandlerContext, throwable, true, false, true);
        }
        PlatformDependent.throwException(throwable);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws SSLException {
        if (this.isStateSet(128)) {
            return;
        }
        if (this.jdkCompatibilityMode) {
            this.decodeJdkCompatible(channelHandlerContext, byteBuf);
        } else {
            this.decodeNonJdkCompatible(channelHandlerContext, byteBuf);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.channelReadComplete0(channelHandlerContext);
    }

    private void channelReadComplete0(ChannelHandlerContext channelHandlerContext) {
        this.discardSomeReadBytes();
        this.flushIfNeeded(channelHandlerContext);
        this.readIfNeeded(channelHandlerContext);
        this.clearState(256);
        channelHandlerContext.fireChannelReadComplete();
    }

    private void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!(channelHandlerContext.channel().config().isAutoRead() || this.isStateSet(256) && this.handshakePromise.isDone())) {
            channelHandlerContext.read();
        }
    }

    private void flushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (this.isStateSet(16)) {
            this.forceFlush(channelHandlerContext);
        }
    }

    private int unwrapNonAppData(ChannelHandlerContext channelHandlerContext) throws SSLException {
        return this.unwrap(channelHandlerContext, Unpooled.EMPTY_BUFFER, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unwrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n) throws SSLException {
        int n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ByteBuf byteBuf2 = this.allocate(channelHandlerContext, n);
        try {
            do {
                int n3;
                SSLEngineResult sSLEngineResult = this.engineType.unwrap(this, byteBuf, n, byteBuf2);
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                int n4 = sSLEngineResult.bytesProduced();
                int n5 = sSLEngineResult.bytesConsumed();
                byteBuf.skipBytes(n5);
                n -= n5;
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    bl |= (!byteBuf2.isReadable() ? this.setHandshakeSuccess() : this.setHandshakeSuccessUnwrapMarkReentry()) || handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED;
                }
                if (byteBuf2.isReadable()) {
                    this.setState(256);
                    if (this.isStateSet(512)) {
                        bl3 = true;
                        this.executeChannelRead(channelHandlerContext, byteBuf2);
                    } else {
                        channelHandlerContext.fireChannelRead(byteBuf2);
                    }
                    byteBuf2 = null;
                }
                if (status == SSLEngineResult.Status.CLOSED) {
                    bl2 = true;
                } else if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (byteBuf2 != null) {
                        byteBuf2.release();
                    }
                    byteBuf2 = this.allocate(channelHandlerContext, this.engineType.calculatePendingData(this, (n3 = this.engine.getSession().getApplicationBufferSize()) < n4 ? n3 : n3 - n4));
                    continue;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    n3 = this.runDelegatedTasks(true);
                    if (n3 == 0) {
                        bl = false;
                        break;
                    }
                } else if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && this.wrapNonAppData(channelHandlerContext, true) && n == 0) break;
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW || handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && (n5 == 0 && n4 == 0 || n == 0 && handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
                    if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                    this.readIfNeeded(channelHandlerContext);
                    break;
                }
                if (byteBuf2 != null) continue;
                byteBuf2 = this.allocate(channelHandlerContext, n);
            } while (!channelHandlerContext.isRemoved());
            if (this.isStateSet(2) && this.handshakePromise.isDone()) {
                this.clearState(2);
                bl = true;
            }
            if (bl) {
                this.wrap(channelHandlerContext, true);
            }
        }
        finally {
            if (byteBuf2 != null) {
                byteBuf2.release();
            }
            if (bl2) {
                if (bl3) {
                    this.executeNotifyClosePromise(channelHandlerContext);
                } else {
                    this.notifyClosePromise(null);
                }
            }
        }
        return n2 - n;
    }

    private boolean setHandshakeSuccessUnwrapMarkReentry() {
        boolean bl;
        boolean bl2 = bl = !this.isStateSet(512);
        if (bl) {
            this.setState(512);
        }
        try {
            boolean bl3 = this.setHandshakeSuccess();
            return bl3;
        }
        finally {
            if (bl) {
                this.clearState(512);
            }
        }
    }

    private void executeNotifyClosePromise(ChannelHandlerContext channelHandlerContext) {
        try {
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.notifyClosePromise(null);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.notifyClosePromise(rejectedExecutionException);
        }
    }

    private void executeChannelRead(final ChannelHandlerContext channelHandlerContext, final ByteBuf byteBuf) {
        try {
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    channelHandlerContext.fireChannelRead(byteBuf);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            byteBuf.release();
            throw rejectedExecutionException;
        }
    }

    private static ByteBuffer toByteBuffer(ByteBuf byteBuf, int n, int n2) {
        return byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(n, n2) : byteBuf.nioBuffer(n, n2);
    }

    private static boolean inEventLoop(Executor executor) {
        return executor instanceof EventExecutor && ((EventExecutor)executor).inEventLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean runDelegatedTasks(boolean var1_1) {
        block9: {
            if (this.delegatedTaskExecutor != ImmediateExecutor.INSTANCE && !SslHandler.inEventLoop(this.delegatedTaskExecutor)) break block9;
            while (true) lbl-1000:
            // 6 sources

            {
                if ((var2_2 = this.engine.getDelegatedTask()) == null) {
                    return true;
                }
                this.setState(128);
                if (var2_2 instanceof AsyncRunnable) {
                    var3_3 = false;
                    try {
                        var4_4 = (AsyncRunnable)var2_2;
                        var5_5 = new AsyncTaskCompletionHandler(var1_1);
                        var4_4.run(var5_5);
                        var3_3 = var5_5.resumeLater();
                        if (!var3_3) ** GOTO lbl-1000
                        var6_6 = false;
                        return var6_6;
                    }
                    finally {
                        if (var3_3) ** GOTO lbl-1000
                        this.clearState(128);
                    }
                    continue;
                }
                try {
                    var2_2.run();
                }
                finally {
                    this.clearState(128);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
        }
        this.executeDelegatedTask(var1_1);
        return false;
    }

    private SslTasksRunner getTaskRunner(boolean bl) {
        return bl ? this.sslTaskRunnerForUnwrap : this.sslTaskRunner;
    }

    private void executeDelegatedTask(boolean bl) {
        this.executeDelegatedTask(this.getTaskRunner(bl));
    }

    private void executeDelegatedTask(SslTasksRunner sslTasksRunner) {
        this.setState(128);
        try {
            this.delegatedTaskExecutor.execute(sslTasksRunner);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.clearState(128);
            throw rejectedExecutionException;
        }
    }

    private boolean setHandshakeSuccess() {
        boolean bl = !this.handshakePromise.isDone() && this.handshakePromise.trySuccess(this.ctx.channel());
        if (bl) {
            if (logger.isDebugEnabled()) {
                SSLSession sSLSession = this.engine.getSession();
                logger.debug("{} HANDSHAKEN: protocol:{} cipher suite:{}", this.ctx.channel(), sSLSession.getProtocol(), sSLSession.getCipherSuite());
            }
            this.ctx.fireUserEventTriggered(SslHandshakeCompletionEvent.SUCCESS);
        }
        if (this.isStateSet(4)) {
            this.clearState(4);
            if (!this.ctx.channel().config().isAutoRead()) {
                this.ctx.read();
            }
        }
        return bl;
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.setHandshakeFailure(channelHandlerContext, throwable, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl, boolean bl2, boolean bl3) {
        try {
            block7: {
                this.setState(32);
                this.engine.closeOutbound();
                if (bl) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException sSLException) {
                        String string;
                        if (!logger.isDebugEnabled() || (string = sSLException.getMessage()) != null && (string.contains("possible truncation attack") || string.contains("closing inbound before receiving peer's close_notify"))) break block7;
                        logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)channelHandlerContext.channel(), (Object)sSLException);
                    }
                }
            }
            if (this.handshakePromise.tryFailure(throwable) || bl3) {
                SslUtils.handleHandshakeFailure(channelHandlerContext, throwable, bl2);
            }
        }
        finally {
            this.releaseAndFailAll(channelHandlerContext, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailureTransportFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        try {
            SSLException sSLException = new SSLException("failure when writing TLS control frames", throwable);
            this.releaseAndFailAll(channelHandlerContext, sSLException);
            if (this.handshakePromise.tryFailure(sSLException)) {
                channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(sSLException));
            }
        }
        finally {
            channelHandlerContext.close();
        }
    }

    private void releaseAndFailAll(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.releaseAndFailAll(channelHandlerContext, throwable);
        }
    }

    private void notifyClosePromise(Throwable throwable) {
        if (throwable == null) {
            if (this.sslClosePromise.trySuccess(this.ctx.channel())) {
                this.ctx.fireUserEventTriggered(SslCloseCompletionEvent.SUCCESS);
            }
        } else if (this.sslClosePromise.tryFailure(throwable)) {
            this.ctx.fireUserEventTriggered(new SslCloseCompletionEvent(throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundAndChannel(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, boolean bl) throws Exception {
        block7: {
            this.setState(32);
            this.engine.closeOutbound();
            if (!channelHandlerContext.channel().isActive()) {
                if (bl) {
                    channelHandlerContext.disconnect(channelPromise);
                } else {
                    channelHandlerContext.close(channelPromise);
                }
                return;
            }
            ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
            try {
                this.flush(channelHandlerContext, channelPromise2);
                if (this.isStateSet(64)) break block7;
                this.setState(64);
                this.safeClose(channelHandlerContext, channelPromise2, PromiseNotifier.cascade(false, channelHandlerContext.newPromise(), channelPromise));
            }
            catch (Throwable throwable) {
                if (!this.isStateSet(64)) {
                    this.setState(64);
                    this.safeClose(channelHandlerContext, channelPromise2, PromiseNotifier.cascade(false, channelHandlerContext.newPromise(), channelPromise));
                } else {
                    this.sslClosePromise.addListener(new FutureListener<Channel>(channelPromise){
                        final /* synthetic */ ChannelPromise val$promise;
                        {
                            this.val$promise = channelPromise;
                        }

                        @Override
                        public void operationComplete(Future<Channel> future) {
                            this.val$promise.setSuccess();
                        }
                    });
                }
                throw throwable;
            }
        }
        this.sslClosePromise.addListener(new /* invalid duplicate definition of identical inner class */);
    }

    private void flush(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelPromise);
        } else {
            channelPromise.setFailure(SslHandler.newPendingWritesNullException());
        }
        this.flush(channelHandlerContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        Channel channel = channelHandlerContext.channel();
        this.pendingUnencryptedWrites = new SslHandlerCoalescingBufferQueue(channel, 16);
        this.setOpensslEngineSocketFd(channel);
        boolean bl = Boolean.TRUE.equals(channel.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT));
        boolean bl2 = channel.isActive();
        if (bl2 || bl) {
            ChannelOutboundBuffer channelOutboundBuffer;
            this.startHandshakeProcessing(bl2);
            if (bl && ((channelOutboundBuffer = channel.unsafe().outboundBuffer()) == null || channelOutboundBuffer.totalPendingWriteBytes() > 0L)) {
                this.setState(16);
            }
        }
    }

    private void startHandshakeProcessing(boolean bl) {
        if (!this.isStateSet(8)) {
            this.setState(8);
            if (this.engine.getUseClientMode()) {
                this.handshake(bl);
            }
            this.applyHandshakeTimeout();
        } else if (this.isStateSet(16)) {
            this.forceFlush(this.ctx);
        }
    }

    public Future<Channel> renegotiate() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        return this.renegotiate(channelHandlerContext.executor().newPromise());
    }

    public Future<Channel> renegotiate(final Promise<Channel> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (!eventExecutor.inEventLoop()) {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.renegotiateOnEventLoop(promise);
                }
            });
            return promise;
        }
        this.renegotiateOnEventLoop(promise);
        return promise;
    }

    private void renegotiateOnEventLoop(Promise<Channel> promise) {
        Promise<Channel> promise2 = this.handshakePromise;
        if (!promise2.isDone()) {
            PromiseNotifier.cascade(promise2, promise);
        } else {
            this.handshakePromise = promise;
            this.handshake(true);
            this.applyHandshakeTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake(boolean bl) {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return;
        }
        if (this.handshakePromise.isDone()) {
            return;
        }
        ChannelHandlerContext channelHandlerContext = this.ctx;
        try {
            this.engine.beginHandshake();
            this.wrapNonAppData(channelHandlerContext, false);
        }
        catch (Throwable throwable) {
            this.setHandshakeFailure(channelHandlerContext, throwable);
        }
        finally {
            if (bl) {
                this.forceFlush(channelHandlerContext);
            }
        }
    }

    private void applyHandshakeTimeout() {
        final Promise<Channel> promise = this.handshakePromise;
        final long l = this.handshakeTimeoutMillis;
        if (l <= 0L || promise.isDone()) {
            return;
        }
        final ScheduledFuture<?> scheduledFuture = this.ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (promise.isDone()) {
                    return;
                }
                SslHandshakeTimeoutException sslHandshakeTimeoutException = new SslHandshakeTimeoutException("handshake timed out after " + l + "ms");
                try {
                    if (promise.tryFailure(sslHandshakeTimeoutException)) {
                        SslUtils.handleHandshakeFailure(SslHandler.this.ctx, sslHandshakeTimeoutException, true);
                    }
                }
                finally {
                    SslHandler.this.releaseAndFailAll(SslHandler.this.ctx, sslHandshakeTimeoutException);
                }
            }
        }, l, TimeUnit.MILLISECONDS);
        promise.addListener((GenericFutureListener<Future<Channel>>)new FutureListener<Channel>(){

            @Override
            public void operationComplete(Future<Channel> future) throws Exception {
                scheduledFuture.cancel(false);
            }
        });
    }

    private void forceFlush(ChannelHandlerContext channelHandlerContext) {
        this.clearState(16);
        channelHandlerContext.flush();
    }

    private void setOpensslEngineSocketFd(Channel channel) {
        if (channel instanceof UnixChannel && this.engine instanceof ReferenceCountedOpenSslEngine) {
            ((ReferenceCountedOpenSslEngine)this.engine).bioSetFd(((UnixChannel)channel).fd().intValue());
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.setOpensslEngineSocketFd(channelHandlerContext.channel());
        if (!this.startTls) {
            this.startHandshakeProcessing(true);
        }
        channelHandlerContext.fireChannelActive();
    }

    private void safeClose(final ChannelHandlerContext channelHandlerContext, final ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        long l;
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        final ScheduledFuture<?> scheduledFuture = !channelFuture.isDone() ? ((l = this.closeNotifyFlushTimeoutMillis) > 0L ? channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!channelFuture.isDone()) {
                    logger.warn("{} Last write attempt timed out; force-closing the connection.", (Object)channelHandlerContext.channel());
                    SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                }
            }
        }, l, TimeUnit.MILLISECONDS) : null) : null;
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) {
                long l;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                if ((l = SslHandler.this.closeNotifyReadTimeoutMillis) <= 0L) {
                    SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                } else {
                    final ScheduledFuture<?> scheduledFuture2 = !SslHandler.this.sslClosePromise.isDone() ? channelHandlerContext.executor().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (!SslHandler.this.sslClosePromise.isDone()) {
                                logger.debug("{} did not receive close_notify in {}ms; force-closing the connection.", (Object)channelHandlerContext.channel(), (Object)l);
                                SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                            }
                        }
                    }, l, TimeUnit.MILLISECONDS) : null;
                    SslHandler.this.sslClosePromise.addListener(new FutureListener<Channel>(){

                        @Override
                        public void operationComplete(Future<Channel> future) throws Exception {
                            if (scheduledFuture2 != null) {
                                scheduledFuture2.cancel(false);
                            }
                            SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                        }
                    });
                }
            }
        });
    }

    private static void addCloseListener(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        PromiseNotifier.cascade(false, channelFuture, channelPromise);
    }

    private ByteBuf allocate(ChannelHandlerContext channelHandlerContext, int n) {
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        if (this.engineType.wantsDirectBuffer) {
            return byteBufAllocator.directBuffer(n);
        }
        return byteBufAllocator.buffer(n);
    }

    private ByteBuf allocateOutNetBuf(ChannelHandlerContext channelHandlerContext, int n, int n2) {
        return this.engineType.allocateWrapBuffer(this, channelHandlerContext.alloc(), n, n2);
    }

    private boolean isStateSet(int n) {
        return (this.state & n) == n;
    }

    private void setState(int n) {
        this.state = (short)(this.state | n);
    }

    private void clearState(int n) {
        this.state = (short)(this.state & ~n);
    }

    private static boolean attemptCopyToCumulation(ByteBuf byteBuf, ByteBuf byteBuf2, int n) {
        int n2 = byteBuf2.readableBytes();
        int n3 = byteBuf.capacity();
        if (n - byteBuf.readableBytes() >= n2 && (byteBuf.isWritable(n2) && n3 >= n || n3 < n && ByteBufUtil.ensureWritableSuccess(byteBuf.ensureWritable(n2, false)))) {
            byteBuf.writeBytes(byteBuf2);
            byteBuf2.release();
            return true;
        }
        return false;
    }

    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        @Override
        protected EventExecutor executor() {
            if (SslHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return SslHandler.this.ctx.executor();
        }

        @Override
        protected void checkDeadLock() {
            if (SslHandler.this.ctx == null) {
                return;
            }
            super.checkDeadLock();
        }
    }

    private final class SslHandlerCoalescingBufferQueue
    extends AbstractCoalescingBufferQueue {
        SslHandlerCoalescingBufferQueue(Channel channel, int n) {
            super(channel, n);
        }

        @Override
        protected ByteBuf compose(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
            int n = SslHandler.this.wrapDataSize;
            if (byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
                int n2 = compositeByteBuf.numComponents();
                if (n2 == 0 || !SslHandler.attemptCopyToCumulation(compositeByteBuf.internalComponent(n2 - 1), byteBuf2, n)) {
                    compositeByteBuf.addComponent(true, byteBuf2);
                }
                return compositeByteBuf;
            }
            return SslHandler.attemptCopyToCumulation(byteBuf, byteBuf2, n) ? byteBuf : this.copyAndCompose(byteBufAllocator, byteBuf, byteBuf2);
        }

        @Override
        protected ByteBuf composeFirst(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) {
            if (byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
                byteBuf = ((SslHandler)SslHandler.this).engineType.wantsDirectBuffer ? byteBufAllocator.directBuffer(compositeByteBuf.readableBytes()) : byteBufAllocator.heapBuffer(compositeByteBuf.readableBytes());
                try {
                    byteBuf.writeBytes(compositeByteBuf);
                }
                catch (Throwable throwable) {
                    byteBuf.release();
                    PlatformDependent.throwException(throwable);
                }
                compositeByteBuf.release();
            }
            return byteBuf;
        }

        @Override
        protected ByteBuf removeEmptyValue() {
            return null;
        }
    }

    private final class SslTasksRunner
    implements Runnable {
        private final boolean inUnwrap;
        private final Runnable runCompleteTask = new Runnable(){

            @Override
            public void run() {
                SslTasksRunner.this.runComplete();
            }
        };

        SslTasksRunner(boolean bl) {
            this.inUnwrap = bl;
        }

        private void taskError(Throwable throwable) {
            if (this.inUnwrap) {
                try {
                    SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, throwable);
                }
                catch (Throwable throwable2) {
                    this.safeExceptionCaught(throwable2);
                }
            } else {
                SslHandler.this.setHandshakeFailure(SslHandler.this.ctx, throwable);
                SslHandler.this.forceFlush(SslHandler.this.ctx);
            }
        }

        private void safeExceptionCaught(Throwable throwable) {
            try {
                SslHandler.this.exceptionCaught(SslHandler.this.ctx, this.wrapIfNeeded(throwable));
            }
            catch (Throwable throwable2) {
                SslHandler.this.ctx.fireExceptionCaught(throwable2);
            }
        }

        private Throwable wrapIfNeeded(Throwable throwable) {
            if (!this.inUnwrap) {
                return throwable;
            }
            return throwable instanceof DecoderException ? throwable : new DecoderException(throwable);
        }

        private void tryDecodeAgain() {
            try {
                SslHandler.this.channelRead(SslHandler.this.ctx, Unpooled.EMPTY_BUFFER);
            }
            catch (Throwable throwable) {
                this.safeExceptionCaught(throwable);
            }
            finally {
                SslHandler.this.channelReadComplete0(SslHandler.this.ctx);
            }
        }

        private void resumeOnEventExecutor() {
            assert (SslHandler.this.ctx.executor().inEventLoop());
            SslHandler.this.clearState(128);
            try {
                SSLEngineResult.HandshakeStatus handshakeStatus = SslHandler.this.engine.getHandshakeStatus();
                switch (handshakeStatus) {
                    case NEED_TASK: {
                        SslHandler.this.executeDelegatedTask(this);
                        break;
                    }
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        SslHandler.this.setHandshakeSuccess();
                        try {
                            SslHandler.this.wrap(SslHandler.this.ctx, this.inUnwrap);
                        }
                        catch (Throwable throwable) {
                            this.taskError(throwable);
                            return;
                        }
                        if (this.inUnwrap) {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        SslHandler.this.forceFlush(SslHandler.this.ctx);
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_UNWRAP: {
                        try {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        catch (SSLException sSLException) {
                            SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, sSLException);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_WRAP: {
                        try {
                            if (!SslHandler.this.wrapNonAppData(SslHandler.this.ctx, false) && this.inUnwrap) {
                                SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                            }
                            SslHandler.this.forceFlush(SslHandler.this.ctx);
                        }
                        catch (Throwable throwable) {
                            this.taskError(throwable);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (Throwable throwable) {
                this.safeExceptionCaught(throwable);
            }
        }

        void runComplete() {
            EventExecutor eventExecutor = SslHandler.this.ctx.executor();
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SslTasksRunner.this.resumeOnEventExecutor();
                }
            });
        }

        @Override
        public void run() {
            try {
                Runnable runnable = SslHandler.this.engine.getDelegatedTask();
                if (runnable == null) {
                    return;
                }
                if (runnable instanceof AsyncRunnable) {
                    AsyncRunnable asyncRunnable = (AsyncRunnable)runnable;
                    asyncRunnable.run(this.runCompleteTask);
                } else {
                    runnable.run();
                    this.runComplete();
                }
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }

        private void handleException(final Throwable throwable) {
            EventExecutor eventExecutor = SslHandler.this.ctx.executor();
            if (eventExecutor.inEventLoop()) {
                SslHandler.this.clearState(128);
                this.safeExceptionCaught(throwable);
            } else {
                try {
                    eventExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            SslHandler.this.clearState(128);
                            SslTasksRunner.this.safeExceptionCaught(throwable);
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    SslHandler.this.clearState(128);
                    SslHandler.this.ctx.fireExceptionCaught(throwable);
                }
            }
        }
    }

    private final class AsyncTaskCompletionHandler
    implements Runnable {
        private final boolean inUnwrap;
        boolean didRun;
        boolean resumeLater;

        AsyncTaskCompletionHandler(boolean bl) {
            this.inUnwrap = bl;
        }

        @Override
        public void run() {
            this.didRun = true;
            if (this.resumeLater) {
                SslHandler.this.getTaskRunner(this.inUnwrap).runComplete();
            }
        }

        boolean resumeLater() {
            if (!this.didRun) {
                this.resumeLater = true;
                return true;
            }
            return false;
        }
    }

    private static enum SslEngineType {
        TCNATIVE(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            SSLEngineResult unwrap(SslHandler sslHandler, ByteBuf byteBuf, int n, ByteBuf byteBuf2) throws SSLException {
                SSLEngineResult sSLEngineResult;
                int n2 = byteBuf.nioBufferCount();
                int n3 = byteBuf2.writerIndex();
                if (n2 > 1) {
                    ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = (ReferenceCountedOpenSslEngine)sslHandler.engine;
                    try {
                        ((SslHandler)sslHandler).singleBuffer[0] = SslHandler.toByteBuffer(byteBuf2, n3, byteBuf2.writableBytes());
                        sSLEngineResult = referenceCountedOpenSslEngine.unwrap(byteBuf.nioBuffers(byteBuf.readerIndex(), n), sslHandler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)sslHandler).singleBuffer[0] = null;
                    }
                } else {
                    sSLEngineResult = sslHandler.engine.unwrap(SslHandler.toByteBuffer(byteBuf, byteBuf.readerIndex(), n), SslHandler.toByteBuffer(byteBuf2, n3, byteBuf2.writableBytes()));
                }
                byteBuf2.writerIndex(n3 + sSLEngineResult.bytesProduced());
                return sSLEngineResult;
            }

            @Override
            ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n, int n2) {
                return byteBufAllocator.directBuffer(((ReferenceCountedOpenSslEngine)sslHandler.engine).calculateMaxLengthForWrap(n, n2));
            }

            @Override
            int calculatePendingData(SslHandler sslHandler, int n) {
                int n2 = ((ReferenceCountedOpenSslEngine)sslHandler.engine).sslPending();
                return n2 > 0 ? n2 : n;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return ((ReferenceCountedOpenSslEngine)sSLEngine).jdkCompatibilityMode;
            }
        }
        ,
        CONSCRYPT(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            SSLEngineResult unwrap(SslHandler sslHandler, ByteBuf byteBuf, int n, ByteBuf byteBuf2) throws SSLException {
                SSLEngineResult sSLEngineResult;
                int n2 = byteBuf.nioBufferCount();
                int n3 = byteBuf2.writerIndex();
                if (n2 > 1) {
                    try {
                        ((SslHandler)sslHandler).singleBuffer[0] = SslHandler.toByteBuffer(byteBuf2, n3, byteBuf2.writableBytes());
                        sSLEngineResult = ((ConscryptAlpnSslEngine)sslHandler.engine).unwrap(byteBuf.nioBuffers(byteBuf.readerIndex(), n), sslHandler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)sslHandler).singleBuffer[0] = null;
                    }
                } else {
                    sSLEngineResult = sslHandler.engine.unwrap(SslHandler.toByteBuffer(byteBuf, byteBuf.readerIndex(), n), SslHandler.toByteBuffer(byteBuf2, n3, byteBuf2.writableBytes()));
                }
                byteBuf2.writerIndex(n3 + sSLEngineResult.bytesProduced());
                return sSLEngineResult;
            }

            @Override
            ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n, int n2) {
                return byteBufAllocator.directBuffer(((ConscryptAlpnSslEngine)sslHandler.engine).calculateOutNetBufSize(n, n2));
            }

            @Override
            int calculatePendingData(SslHandler sslHandler, int n) {
                return n;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return true;
            }
        }
        ,
        JDK(false, ByteToMessageDecoder.MERGE_CUMULATOR){

            @Override
            SSLEngineResult unwrap(SslHandler sslHandler, ByteBuf byteBuf, int n, ByteBuf byteBuf2) throws SSLException {
                int n2;
                int n3 = byteBuf2.writerIndex();
                ByteBuffer byteBuffer = SslHandler.toByteBuffer(byteBuf, byteBuf.readerIndex(), n);
                int n4 = byteBuffer.position();
                SSLEngineResult sSLEngineResult = sslHandler.engine.unwrap(byteBuffer, SslHandler.toByteBuffer(byteBuf2, n3, byteBuf2.writableBytes()));
                byteBuf2.writerIndex(n3 + sSLEngineResult.bytesProduced());
                if (sSLEngineResult.bytesConsumed() == 0 && (n2 = byteBuffer.position() - n4) != sSLEngineResult.bytesConsumed()) {
                    return new SSLEngineResult(sSLEngineResult.getStatus(), sSLEngineResult.getHandshakeStatus(), n2, sSLEngineResult.bytesProduced());
                }
                return sSLEngineResult;
            }

            @Override
            ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n, int n2) {
                return byteBufAllocator.heapBuffer(sslHandler.engine.getSession().getPacketBufferSize());
            }

            @Override
            int calculatePendingData(SslHandler sslHandler, int n) {
                return n;
            }

            @Override
            boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return true;
            }
        };

        final boolean wantsDirectBuffer;
        final ByteToMessageDecoder.Cumulator cumulator;

        static SslEngineType forEngine(SSLEngine sSLEngine) {
            return sSLEngine instanceof ReferenceCountedOpenSslEngine ? TCNATIVE : (sSLEngine instanceof ConscryptAlpnSslEngine ? CONSCRYPT : JDK);
        }

        private SslEngineType(boolean bl, ByteToMessageDecoder.Cumulator cumulator) {
            this.wantsDirectBuffer = bl;
            this.cumulator = cumulator;
        }

        abstract SSLEngineResult unwrap(SslHandler var1, ByteBuf var2, int var3, ByteBuf var4) throws SSLException;

        abstract int calculatePendingData(SslHandler var1, int var2);

        abstract boolean jdkCompatibilityMode(SSLEngine var1);

        abstract ByteBuf allocateWrapBuffer(SslHandler var1, ByteBufAllocator var2, int var3, int var4);
    }
}

