/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.stream;

import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelProgressivePromise;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedInput;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class ChunkedWriteHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<PendingWrite> queue = new ArrayDeque<PendingWrite>();
    private volatile ChannelHandlerContext ctx;

    public ChunkedWriteHandler() {
    }

    @Deprecated
    public ChunkedWriteHandler(int n) {
        ObjectUtil.checkPositive(n, "maxPendingWrites");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
    }

    public void resumeTransfer() {
        final ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            return;
        }
        if (channelHandlerContext.executor().inEventLoop()) {
            this.resumeTransfer0(channelHandlerContext);
        } else {
            channelHandlerContext.executor().execute(new Runnable(){

                @Override
                public void run() {
                    ChunkedWriteHandler.this.resumeTransfer0(channelHandlerContext);
                }
            });
        }
    }

    private void resumeTransfer0(ChannelHandlerContext channelHandlerContext) {
        try {
            this.doFlush(channelHandlerContext);
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while sending chunks.", exception);
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        this.queue.add(new PendingWrite(object, channelPromise));
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.doFlush(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.doFlush(channelHandlerContext);
        channelHandlerContext.fireChannelInactive();
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (channelHandlerContext.channel().isWritable()) {
            this.doFlush(channelHandlerContext);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    private void discard(Throwable throwable) {
        PendingWrite pendingWrite;
        while ((pendingWrite = this.queue.poll()) != null) {
            Object object = pendingWrite.msg;
            if (object instanceof ChunkedInput) {
                long l;
                boolean bl;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                try {
                    bl = chunkedInput.isEndOfInput();
                    l = chunkedInput.length();
                    ChunkedWriteHandler.closeInput(chunkedInput);
                }
                catch (Exception exception) {
                    ChunkedWriteHandler.closeInput(chunkedInput);
                    pendingWrite.fail(exception);
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn(ChunkedInput.class.getSimpleName() + " failed", exception);
                    continue;
                }
                if (!bl) {
                    if (throwable == null) {
                        throwable = new ClosedChannelException();
                    }
                    pendingWrite.fail(throwable);
                    continue;
                }
                pendingWrite.success(l);
                continue;
            }
            if (throwable == null) {
                throwable = new ClosedChannelException();
            }
            pendingWrite.fail(throwable);
        }
    }

    private void doFlush(ChannelHandlerContext channelHandlerContext) {
        PendingWrite pendingWrite;
        Channel channel = channelHandlerContext.channel();
        if (!channel.isActive()) {
            this.discard(null);
            return;
        }
        boolean bl = true;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        while (channel.isWritable() && (pendingWrite = this.queue.peek()) != null) {
            if (pendingWrite.promise.isDone()) {
                this.queue.remove();
                continue;
            }
            Object object = pendingWrite.msg;
            if (object instanceof ChunkedInput) {
                boolean bl2;
                boolean bl3;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                ByteBuf byteBuf = null;
                try {
                    byteBuf = (ByteBuf)chunkedInput.readChunk(byteBufAllocator);
                    bl3 = chunkedInput.isEndOfInput();
                    bl2 = byteBuf == null ? !bl3 : false;
                }
                catch (Throwable throwable) {
                    this.queue.remove();
                    if (byteBuf != null) {
                        ReferenceCountUtil.release(byteBuf);
                    }
                    ChunkedWriteHandler.closeInput(chunkedInput);
                    pendingWrite.fail(throwable);
                    break;
                }
                if (bl2) break;
                if (byteBuf == null) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                }
                if (bl3) {
                    this.queue.remove();
                }
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(byteBuf);
                if (bl3) {
                    if (channelFuture.isDone()) {
                        ChunkedWriteHandler.handleEndOfInputFuture(channelFuture, pendingWrite);
                    } else {
                        channelFuture.addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture channelFuture) {
                                ChunkedWriteHandler.handleEndOfInputFuture(channelFuture, pendingWrite);
                            }
                        });
                    }
                } else {
                    boolean bl4;
                    boolean bl5 = bl4 = !channel.isWritable();
                    if (channelFuture.isDone()) {
                        this.handleFuture(channelFuture, pendingWrite, bl4);
                    } else {
                        channelFuture.addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture channelFuture) {
                                ChunkedWriteHandler.this.handleFuture(channelFuture, pendingWrite, bl4);
                            }
                        });
                    }
                }
                bl = false;
            } else {
                this.queue.remove();
                channelHandlerContext.write(object, pendingWrite.promise);
                bl = true;
            }
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        if (bl) {
            channelHandlerContext.flush();
        }
    }

    private static void handleEndOfInputFuture(ChannelFuture channelFuture, PendingWrite pendingWrite) {
        ChunkedInput chunkedInput = (ChunkedInput)pendingWrite.msg;
        if (!channelFuture.isSuccess()) {
            ChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.fail(channelFuture.cause());
        } else {
            long l = chunkedInput.progress();
            long l2 = chunkedInput.length();
            ChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.progress(l, l2);
            pendingWrite.success(l2);
        }
    }

    private void handleFuture(ChannelFuture channelFuture, PendingWrite pendingWrite, boolean bl) {
        ChunkedInput chunkedInput = (ChunkedInput)pendingWrite.msg;
        if (!channelFuture.isSuccess()) {
            ChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.fail(channelFuture.cause());
        } else {
            pendingWrite.progress(chunkedInput.progress(), chunkedInput.length());
            if (bl && channelFuture.channel().isWritable()) {
                this.resumeTransfer();
            }
        }
    }

    private static void closeInput(ChunkedInput<?> chunkedInput) {
        block2: {
            try {
                chunkedInput.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a chunked input.", throwable);
            }
        }
    }

    private static final class PendingWrite {
        final Object msg;
        final ChannelPromise promise;

        PendingWrite(Object object, ChannelPromise channelPromise) {
            this.msg = object;
            this.promise = channelPromise;
        }

        void fail(Throwable throwable) {
            ReferenceCountUtil.release(this.msg);
            this.promise.tryFailure(throwable);
        }

        void success(long l) {
            if (this.promise.isDone()) {
                return;
            }
            this.progress(l, l);
            this.promise.trySuccess();
        }

        void progress(long l, long l2) {
            if (this.promise instanceof ChannelProgressivePromise) {
                ((ChannelProgressivePromise)this.promise).tryProgress(l, l2);
            }
        }
    }
}

