/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.concurrent;

import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocalRunnable;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocalThread;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolId = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;
    private final int priority;
    protected final ThreadGroup threadGroup;

    public DefaultThreadFactory(Class<?> clazz) {
        this(clazz, false, 5);
    }

    public DefaultThreadFactory(String string) {
        this(string, false, 5);
    }

    public DefaultThreadFactory(Class<?> clazz, boolean bl) {
        this(clazz, bl, 5);
    }

    public DefaultThreadFactory(String string, boolean bl) {
        this(string, bl, 5);
    }

    public DefaultThreadFactory(Class<?> clazz, int n) {
        this(clazz, false, n);
    }

    public DefaultThreadFactory(String string, int n) {
        this(string, false, n);
    }

    public DefaultThreadFactory(Class<?> clazz, boolean bl, int n) {
        this(DefaultThreadFactory.toPoolName(clazz), bl, n);
    }

    public static String toPoolName(Class<?> clazz) {
        ObjectUtil.checkNotNull(clazz, "poolType");
        String string = StringUtil.simpleClassName(clazz);
        switch (string.length()) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return string.toLowerCase(Locale.US);
            }
        }
        if (Character.isUpperCase(string.charAt(0)) && Character.isLowerCase(string.charAt(1))) {
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public DefaultThreadFactory(String string, boolean bl, int n, ThreadGroup threadGroup) {
        ObjectUtil.checkNotNull(string, "poolName");
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException("priority: " + n + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
        }
        this.prefix = string + '-' + poolId.incrementAndGet() + '-';
        this.daemon = bl;
        this.priority = n;
        this.threadGroup = threadGroup;
    }

    public DefaultThreadFactory(String string, boolean bl, int n) {
        this(string, bl, n, null);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.newThread(FastThreadLocalRunnable.wrap(runnable), this.prefix + this.nextId.incrementAndGet());
        try {
            if (thread.isDaemon() != this.daemon) {
                thread.setDaemon(this.daemon);
            }
            if (thread.getPriority() != this.priority) {
                thread.setPriority(this.priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return thread;
    }

    protected Thread newThread(Runnable runnable, String string) {
        return new FastThreadLocalThread(this.threadGroup, runnable, string);
    }
}

