/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.enfs.dir;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import pro.gravit.utils.enfs.dir.FileEntry;

public class CipherFile
extends FileEntry {
    private final Supplier<InputStream> inputStream;
    private final String alg;
    private final byte[] key;

    public CipherFile(Supplier<InputStream> supplier, String string, byte[] byArray) {
        this.inputStream = supplier;
        this.alg = string;
        this.key = byArray;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(this.alg);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.key, this.alg);
            cipher.init(2, secretKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new IOException(generalSecurityException);
        }
        return new CipherInputStream(this.inputStream.get(), cipher);
    }
}

