/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.View;

public class AquaHighlighter
extends DefaultHighlighter
implements UIResource {
    static final AquaUtils.RecyclableSingleton<LayeredHighlighter.LayerPainter> instance = new AquaUtils.RecyclableSingleton<LayeredHighlighter.LayerPainter>(){

        @Override
        protected LayeredHighlighter.LayerPainter getInstance() {
            return new AquaHighlightPainter(null);
        }
    };

    protected static LayeredHighlighter.LayerPainter getInstance() {
        return instance.get();
    }

    public static class AquaHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        Color selectionColor;
        Color disabledSelectionColor;

        public AquaHighlightPainter(Color color) {
            super(color);
        }

        @Override
        public Color getColor() {
            return this.selectionColor == null ? super.getColor() : this.selectionColor;
        }

        protected Color getInactiveSelectionColor() {
            if (this.disabledSelectionColor != null) {
                return this.disabledSelectionColor;
            }
            this.disabledSelectionColor = UIManager.getColor("TextComponent.selectionBackgroundInactive");
            return this.disabledSelectionColor;
        }

        void setColor(JTextComponent jTextComponent) {
            Window window;
            this.selectionColor = super.getColor();
            if (this.selectionColor == null) {
                this.selectionColor = jTextComponent.getSelectionColor();
            }
            if ((window = SwingUtilities.getWindowAncestor(jTextComponent)) != null && !window.isActive()) {
                this.selectionColor = this.getInactiveSelectionColor();
            }
            if (!jTextComponent.hasFocus()) {
                this.selectionColor = this.getInactiveSelectionColor();
            }
        }

        @Override
        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            this.setColor(jTextComponent);
            super.paint(graphics, n, n2, shape, jTextComponent);
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            this.setColor(jTextComponent);
            return super.paintLayer(graphics, n, n2, shape, jTextComponent, view);
        }
    }
}

